;; minlog.el Proof General instance for Minlog
;;
;; Copyright (C) 2004 Stefan Schimanski, Freiric Barral
;;
;; Author: Stefan Schimanski <schimans@math.lmu.de>
;;         Freiric Barral <barral@math.lmu.de>
;;

(defcustom minlog-path "/usr/share/minlog"
  "The Minlog directory, e.g. \"~/minlog\"."
  :type 'directory
  :group 'minlog)

(defcustom minlog-el-path "/usr/share/emacs/site-lisp/minlog"
  "The Minlog Emacs lisp directory where the minlog-mode.el is located, e.g. \"~/minlog\"."
  :type 'directory
  :group 'minlog)

(defcustom minlog-scheme 'auto
  "The scheme interpreter to use."
  :type '(choice (const :tag "auto" auto)
                 (const :tag "guile" guile)
                 (const :tag "mzscheme" mzscheme))
  :group 'minlog)

(defcustom pdf-viewer "xpdf"
  "The Pdf viewer to see the documentation:)"
  :type '(choice (const :tag "acrobat reader" "acroread") 
                 (const :tag "Xpdf" "xpdf")
		 (file :tag  "other pdf viewer" :value "/usr/bin/xpdf"))
  :group 'minlog)

(provide 'minlog-config)
