; ***********************************************************
; ; Adapt path if necessary:
; (define path "~/minlog/examples/tait/diplomarbeit_schlenker/")

; ; Defines the function "pload" to load files 
; ; from the path defined above
; (define pload (lambda (x) (load (string-append path x))))

; ; Used Modules:
; (pload "./initiate.scm")
; (pload "./defsLamCalc.scm")
; (pload "./defsSubst.scm")
; (pload "./omega.scm")
; (pload "./defsNT.scm")
; (pload "./defsAxiomsSpecial.scm")
; (pload "./trivial.scm")
; (pload "./auxGlobal_SHORT.scm")
;
; NOTICE: Uncomment modules only when file is run on its own
; ***********************************************************


; ==================================
;  Section: Auxiliaries for Lemma 1
; ==================================
; contains all auxiliaries for Lemma 1

; Lemma: "LemmaOneAux1"
; ---------------------
(add-global-assumption "LemmaOneAux1"
  (pf "all rhos,rho,sig,r,k.
        Fr rhos(rho to sig)r k -> 
        TypJ(rhos:+:(ExtCtx rhos k rho))(Var k)rho")) 

; Lemma: "LemmaOneAux2"
; ---------------------
(add-global-assumption "LemmaOneAux2"
 (pf "all rhos,rho,sig,r,k.
      Fr rhos(rho to sig)r k -> 
      TypJ(rhos:+:(ExtCtx rhos k rho))(r(Var k))sig"))

; Lemma: "LemmaOneAux3"
; ---------------------
(add-global-assumption "LemmaOneAux3"
 (pf "all rhos,rho,sig,r,k.
        Fr rhos(rho to sig)r k -> 
        Fr(rhos:+:(ExtCtx rhos k rho))sig(r(Var k))(k+1)"))

; Lemma: "LemmaOneAux5"
; ---------------------
(add-global-assumption "LemmaOneAux5"
 (pf "all rhos,sigs,rho,sig,r,s,k.
      Fr(rhos:+:sigs)sig(r s)k -> TypJ(rhos:+:sigs)s rho ->
      Fr(rhos:+:sigs)rho s k"))


; Lemma: "LemmaOneAux7"
; ---------------------
(add-global-assumption "LemmaOneAux7"
 (pf "all rhos,sigs,rho,sig,r,s,k.
      Fr(rhos:+:sigs)sig(r s)k ->
      TypJ rhos r(rho to sig) ->
      Fr rhos(rho to sig)r k"))

; Lemma: "LemmaOneAux8"
; ---------------------
; an auxiliary for Lemma One, which is used several times

(add-global-assumption "LemmaOneAux8"
 (pf "all rhos, sigs, rho, s.
               ex b^ (SCr (rhos:+:sigs) rho b^ s) ->
               TypJ (rhos:+:sigs) s rho"))
