; $Id: higman01.scm 2581 2012-12-27 02:01:15Z miyamoto $
; An inductive proof Higman's Lemma for a 0/1 alphabet
; see Coquand/Fridlender 1994
; We prove that every infinite sequence in a 0/1 alphabet has a good
; initial segment


; 1. Definitions
; ==============

(set! COMMENT-FLAG #f)
(exload "bar/bar.scm")
(set! COMMENT-FLAG #t)
(add-global-assumption
 "OnlyTwoLetters" (pf "all a,b,c((a=b -> F) -> (c=a -> F) -> c=b)"))

; R a vs ws means vs= v1 ... vn, ws = a::v1 ... a::vn

(add-ids
 (list (list "R" (make-arity nat seq seq)))
 '("allnc a R a(Nil list nat)(Nil list nat)" "InitR") 
 '("allnc vs,ws,w,a(R a vs ws -> R a(vs++(w:))(ws++((a::w):)))" "GenR"))

; '("allnc vs,ws,w,a(R a vs ws -> R a(w::vs)((a::w)::ws))" "GenR"))

; TT a ws zs holds iff zs = z_1 ... z_n is of length n>0, all z_p are
; of the form z_p = a_p::u_p, and ws = z_1 ... z_m u_{l_1} ...u_{l_k}
; where m = l_1 < l_2 < ... < l_k is the set of indices p<=n such that
; a_p=a.

(add-ids
 (list (list "TT" (make-arity nat seq seq)))
 '("allnc ws,zs,w,a,b((a=b -> F) -> R b ws zs ->
                      TT a(zs++w:)(zs++(a::w):))" "InitTT")
 '("allnc ws,zs,w,a(TT a ws zs -> TT a(ws++w:)(zs++(a::w):))" "GenTTEq")
 '("allnc ws,zs,w,a,b((a=b -> F) -> TT a ws zs -> TT a ws(zs++(b::w):))"
   "GenTTNeq"))

(display-idpc "Emb" "L" "Good" "R" "TT")

(add-global-assumption
 "Lemma2nc" (pf "allnc ws,zs,a(R a ws zs -> Good ws -> Good zs)"))
(add-global-assumption
 "Lemma3nc" (pf "allnc ws,zs,a(TT a ws zs -> Good ws -> Good zs)"))
(add-global-assumption
 "Lemma4nc" (pf "allnc ws,zs,a((ws=(Nil list nat) -> F) -> 
                       R a ws zs -> TT a ws zs)"))


; 2. Interactive proofs
; =====================

; Prop1 has been proven in bar.scm

; Prop2

(set-goal "allnc xs(Bar xs ->
           allnc ys(Bar ys -> 
           all zs,a,b((a=b -> F) -> TT a xs zs  -> TT b ys zs -> Bar zs)))")
(assume "xs1" "Bxs1")
(elim "Bxs1")

; 1. Good xs 
(assume "xs" "Good xs" "ys" "Bar ys" "zs" "a" "b" "a=b -> F" 
        "TT a xs zs" "TT b ys zs")
(use "Leaf")
(use-with "Lemma3nc" (pt "xs") (pt "zs") (pt "a") "TT a xs zs" "Good xs")

; 2. all w Bar(xs::w)
(assume "xs" "all w Bar(xs++w:)" "IH1" "ys1" "Bys1")
(elim "Bys1")

; 2.1
(assume "ys" "Good ys" "zs" "a" "b" "a=b -> F" "TT a xs zs" "TT b ws zs")
(use "Leaf")
(use-with "Lemma3nc" (pt "ys") (pt "zs") (pt "b") "TT b ws zs" "Good ys")

; 2.2
(assume "ys" "all w Bar(ys++w:)" "IH2" "zs" "a" "b"
	"a=b -> F" "TT a xs zs" "TT b ws zs")
(use "Branch")

; structural induction on w 
(ind) 

; 2.2.1
(use "Prop1")

; 2.2.2
(assume "c" "z" "Bar(zs++z:)")

(cases (pt "c=a"))

(assume "c=a")
(simp "c=a")

(use "IH1" (pt "z") (pt "ys") (pt "a") (pt"b"))
; Bar ys
(use "Branch")

(use "all w Bar(ys++w:)")
; a=b -> F
(use "a=b -> F")

; TT a(xs++z:)(zs++(a::):)
(use "GenTTEq")
(use "TT a xs zs")

; TT b ys(zs++(a::z):)
(use "GenTTNeq")
(assume "b=a")
(use "a=b -> F")
(simp "b=a")
(use "Truth-Axiom")
(use "TT b ws zs")

; false
(assume "c=a -> F")
(cut (pf "c=b"))
(assume "c=b")

(use-with "IH2" (pt "z") (pt "zs++(c::z):") (pt "a") (pt "c") "?" "?" "?")
(assume "a=c")
(use "c=a -> F")
(simp "a=c")
(use "Truth-Axiom")

(simp "c=b")
(use "GenTTNeq")
(use "a=b -> F")
(use "TT a xs zs")

; TT c(ys++z:)(zs++(c::z):) from
(simp "c=b")
(use "GenTTEq")
(use "TT b ws zs")
(use "OnlyTwoLetters" (pt "a"))
(use "a=b -> F")
(use "c=a -> F")
; Proof finished.
(save  "Prop2")

; The extracted program from Prop2

(remove-var-name "gc" "gd" "ge")

(add-var-name "gc" (py "list nat=>list(list nat)=>algBar"))
(add-var-name "gd" (py "list nat=>algBar=>list(list nat)=>nat=>nat=>algBar"))
(add-var-name "ge" (py "list nat=>list(list nat)=>nat=>nat=>algBar"))

(pp (nt (proof-to-extracted-term (theorem-name-to-proof "Prop2"))))

;; [algBar0]
;;  (Rec algBar=>algBar=>list list nat=>nat=>nat=>algBar)algBar0
;;  ([algBar5,ws6,a7,a8]CLeaf)
;;  ([(list nat=>algBar)_5,gd6,algBar7]
;;    (Rec algBar=>list list nat=>nat=>nat=>algBar)algBar7([ws11,a12,a13]CLeaf)
;;    ([(list nat=>algBar)_11,ge12,ws13,a14,a15]
;;      CBranch
;;      ([w16]
;;        [if w16
;;          cPropOne
;;          ([a17,w18]
;;           [if (a17=a14)
;;             (gd6 w18(CBranch(list nat=>algBar)_11)(ws13++(a14::w18):)a14 a15)
;;             (ge12 w18(ws13++(a17::w18):)a14 a17)])])))

; Prop3

(set-goal
 "all a 
 allnc xs(Bar xs -> (xs=(Nil list nat) -> F) -> all zs(R a xs zs -> Bar zs))")
(assume "a" "xs1" "Bxs1")
(elim "Bxs1")

; all ws(good ws -> formula[a,ws])

(assume "xs" "Good xs" "xs ne Nil" "zs" "R a xs zs")
(use "Leaf")
(use-with "Lemma2nc" (pt "xs") (pt "zs") (pt "a") "R a xs zs" "Good xs")

; step
(assume "xs"  "all w Bar xs++w:" "IH"  "xs ne Nil" "zs" "R a xs zs")
(use "Branch")
(ind)
(use "Prop1")
(assume "c" "z" "Bar zs++z:")
(cases (pt "c=a"))
(assume "c=a")
(use-with "IH" (pt "z") "?" (pt "zs++(c::z):") "?")
; xs++z: =(Nil list nat) -> F
(assume "xs++z: =(Nil list nat)")
(assert (pf "Lh(xs++z:)=0"))
 (simp "xs++z: =(Nil list nat)")
 (use "Truth-Axiom")
(assume "Absurd")
(use "Absurd")

; R a(xs++z:)(zs++(c::z):)
(simp "c=a")
(use "GenR")
(use "R a xs zs")

; (c=a -> F) -> Bar(zs++(c::z):)
(assume "c=a -> F")
(cut (pf "a=c -> F"))
(assume "a=c -> F")
(use-with "Prop2"  (pt "xs") "?" 
                   (pt "zs++z:") "Bar zs++z:" 
                   (pt "zs++(c::z):")(pt "a") (pt "c") "?" "?" "?")

; Bar xs
(use "Branch")
(use "all w Bar xs++w:")

; a=c -> F 
(use "a=c -> F")

; TT a xs(zs++(c::z):)
(use "GenTTNeq")
(use "a=c -> F")

; TT a xs zs
(use "Lemma4nc" )
(use "xs ne Nil")
(use "R a xs zs")

; TT c(zs++z:)(zs++(c::z):)
(use "InitTT" (pt "xs") (pt "a"))
(use "c=a -> F")
(use "R a xs zs")

; a=c -> F
(assume "a=c")
(use "c=a -> F")
(simp "a=c")
(use "Truth-Axiom")
; Proof finished.
(save "Prop3")

; The extracted program from Prop3

(pp (nt (proof-to-extracted-term (theorem-name-to-proof "Prop3"))))

;; [a0,algBar1]
;;  (Rec algBar=>list list nat=>algBar)algBar1([ws3]CLeaf)
;;  ([ga3,gc4,ws5]
;;    CBranch
;;    ([w6]
;;      (Rec list nat=>algBar)w6 cPropOne
;;      ([a7,w8,algBar9]
;;        [if (a7=a0)
;;          (gc4 w8(ws5++(a7::w8):))
;;          (cPropTwo(CBranch ga3)algBar9(ws5++(a7::w8):)a0 a7)])))

; The proof of the Theorem

(set-goal "Bar(Nil list nat)")
(use "Branch")

(ind)
;1.
(use "Prop1")
;2.
(assume "a" "w" "Bar((Nil list nat)++w:)")
(use-with "Prop3" (pt "a") (pt "w:") "Bar((Nil list nat)++w:)" "?"
	  (pt "(a::w):") "?")
(ng #t)
(assume "Absurd")
(use "Absurd")

; R a(w:)((a::w):)
(use-with "GenR" (pt "(Nil list nat)") (pt "(Nil list nat)")
	  (pt "w") (pt "a") "?")
(use "InitR")
; Proof finished.
(save "Thm")

(pp (nt (proof-to-extracted-term (theorem-name-to-proof "Thm"))))

;; CBranch
;; ([w0]
;;   (Rec list nat=>algBar)w0 cPropOne
;;   ([a1,w2,algBar3]cPropThree a1 algBar3(a1::w2):))

(set-goal "all f ex m Good(f fbar m)")
(assume "f")
(use-with "BarThm" (pt "(Nil list nat)") "Thm" (pt "f") (pt "0") "?")
; (f fbar 0)=(Nil list nat)
(ng #t)
(use "Truth-Axiom")
; Proof finished.
(save "HigmanThm")

(define eterm (proof-to-extracted-term (theorem-name-to-proof "HigmanThm")))

(animate "BarThm")
(animate "Thm")
(animate "Prop1")
(animate "Prop2")
(animate "Prop3")

(pp eterm)
; [f]cBarThm cThm f 0

(define neterm (nt eterm))
(pp neterm)

;; [f0]
;;  (Rec algBar=>(nat=>list nat)=>nat=>nat)
;;  ((Rec list nat=>algBar)(f0 0)(CBranch([w1]CLeaf))
;;   ([a1,w2,algBar3]
;;     (Rec algBar=>list list nat=>algBar)algBar3([ws4]CLeaf)
;;     ([ga4,gc5,ws6]
;;       CBranch
;;       ([w7]
;;         (Rec list nat=>algBar)w7(CBranch([w8]CLeaf))
;;         ([a8,w9,algBar10]
;;           [if (a8=a1)
;;             (gc5 w9(ws6++(a8::w9):))
;;             ((Rec algBar=>list list nat=>nat=>nat=>algBar)algBar10
;;             ([ws11,a12,a13]CLeaf)
;;             ([ga11,ge12,ws13,a14,a15]
;;               CBranch
;;               ([w16]
;;                 [if w16
;;                   (CBranch([w17]CLeaf))
;;                   ([a17,w18]
;;                    [if (a17=a14)
;;                      ((Rec algBar=>algBar=>list list nat=>nat=>nat=>algBar)
;;                      (ga4 w18)
;;                      ([algBar19,ws20,a21,a22]CLeaf)
;;                      ([ga19,gd20,algBar21]
;;                        (Rec algBar=>list list nat=>nat=>nat=>algBar)algBar21
;;                        ([ws25,a26,a27]CLeaf)
;;                        ([ga25,ge26,ws27,a28,a29]
;;                          CBranch
;;                          ([w30]
;;                            [if w30
;;                              (CBranch([w31]CLeaf))
;;                              ([a31,w32]
;;                               [if (a31=a28)
;;                                 (gd20 w32(CBranch ga25)(ws27++(a28::w32):)a28 
;;                                 a29)
;;                                 (ge26 w32(ws27++(a31::w32):)a28 a31)])])))
;;                      (CBranch ga11)
;;                      (ws13++(a14::w18):)
;;                      a14 
;;                      a15)
;;                      (ge12 w18(ws13++(a17::w18):)a14 a17)])]))
;;             (ws6++(a8::w9):)
;;             a1 
;;             a8)])))
;;     (a1::w2):))
;;  ([f1,a2]a2)
;;  ([ga1,gb2,f3,a4]gb2(f3 a4)f3(Succ a4))
;;  f0 
;;  1


; 3. Test of the extracted term
; =============================

(define (run-higman infinite-sequence)
  (pp (nt (mk-term-in-app-form neterm infinite-sequence))))

; a. [0 0], [1 1 0], [0 1 0 1], [0], ...
(add-program-constant "Seq" (mk-arrow (py "nat") (py "(list nat)")))
(add-rewrite-rule (pt "Seq 0") (pt "0::0:"))
(add-rewrite-rule (pt "Seq 1") (pt "1::1::0:"))
(add-rewrite-rule (pt "Seq 2") (pt "0::1::0::1:"))
(add-rewrite-rule (pt "Seq(n+3)") (pt "0:"))
(run-higman (pt "Seq"))

; ==> 3
; i.e., the subsequence of consisting of the first three words is good.

; b. [0 0], [1], [0 1], [], [], ...

(add-program-constant "Interesting" (mk-arrow (py "nat") (py "(list nat)")))
(add-rewrite-rule (pt "Interesting 0") (pt "0::0:"))
(add-rewrite-rule (pt "Interesting 1") (pt "1:"))
(add-rewrite-rule (pt "Interesting 2") (pt "0::1:"))
(add-rewrite-rule (pt "Interesting 3") (pt "(Nil nat)"))
(add-rewrite-rule (pt "Interesting(n+4)") (pt "(Nil nat)"))
(run-higman (pt "Interesting"))

; ==> 5  
; This is an example in which not the shortest good initial segment is found.
