; $Id: $

; Based on Makoto Takeyama's Agda module ParenDepTac, 2009-06-16

; From a proof of "all x ex p((p -> S x) & ((p -> F) -> S x -> F))" a
; parser-term

;;  [x0]
;;  Test 0 x0@
;;  (Rec list par=>algState=>algS=>algS)x0([st1,b2][if st1 b2 ([b3,st4]cInitS)])
;;  ([par1,x2,f3,st4,b5]
;;    [if par1
;;      (f3(cApState b5 st4)cInitS)
;;      [if st4 cInitS ([b6,st7]f3 st7(cApS b6(cParS b5)))]])
;;  cInitState 
;;  cInitS

; is extracted, and tested in experiments.

(load "~/minlog/init.scm") ;correct path to minlog if necessary.
(set! COMMENT-FLAG #f)
(libload "nat.scm")
(libload "list.scm")
(set! COMMENT-FLAG #t)


(add-alg "par" '("L" "par") '("R" "par"))
(add-totality "par")

(add-var-name "p" (py "boole"))
(add-var-name "x" "y" "z" "s" "t" "u" "v" "w" (py "list par"))

; Inductively define predicates (grammars) U,S over list par, by clauses
; "InitU": U(Nil par)
; "ApU":   allnc x,y(U x -> U y -> U(x++(L::y++R:)))
; "InitS": S(Nil par)
; "ApS":   allnc x,y(S x -> S y -> S(x++y))
; "ParS":  allnc x(S x -> S(L::x++R:))

(add-ids (list (list "U" (make-arity (py "list par")) "algU"))
	 '("U(Nil par)" "InitU")
	 '("allnc x,y(U x -> U y -> U(x++(L::y++R:)))" "ApU"))

(add-ids (list (list "S" (make-arity (py "list par")) "algS"))
	 '("S(Nil par)" "InitS")
	 '("allnc x,y(S x -> S y -> S(x++y))" "ApS")
	 '("allnc x(S x -> S(L::x++R:))" "ParS"))

; "US"
(set-goal (pf "allnc x(U x -> S x)"))
(assume "x" "IdHyp")
(elim "IdHyp")
(use "InitS")
(assume "x1" "y" "U x1" "U y" "S x1" "S y")
(use "ApS")
(auto)
(use "ParS")
(auto)
; Proof finished.
(save "US")

(define eterm (proof-to-extracted-term (theorem-name-to-proof "US")))
(add-var-name "a" (py "algU"))
(add-var-name "b" (py "algS"))
(pp (nt eterm))

; [a0](Rec algU=>algS)a0 CInitS([a1,a2,b3,b4]CApS b3(CParS b4))

; Need a lemma for the other direction

; "AppendU"
(set-goal (pf "allnc x,y(U x -> U y -> U(x++y))"))
(assume "x" "y" "U x" "IdHyp")
(elim "IdHyp")
(auto)

(assume "x1" "y1" "U x1" "U y1" "U(x++x1)" "U(x++y1)")
(simp "ListAppdAssoc")
(use "ApU")
(auto)
; Proof finished
(save "AppendU")

(define eterm (proof-to-extracted-term (theorem-name-to-proof "AppendU")))
(animate "EqDCompatRev")
(pp (nt eterm))

; [a0,a1](Rec algU=>algU)a1 a0([a2,a3,a4,a5]CApU a4 a3)

; "SU"
(set-goal (pf "allnc x(S x -> U x)"))
(assume "x" "IdHyp")
(elim "IdHyp")
(use "InitU")
(assume "x1" "y" "S x1" "S y" "U x1" "U y")
(use "AppendU")
(auto)
(assume "x1" "S x1" "U x1")
(assert (pf "U((Nil par)++(L::x1++R:))"))
 (use "ApU")
 (use "InitU")
 (auto)
; Proof finished
(save "SU")

(define eterm (proof-to-extracted-term (theorem-name-to-proof "SU")))
(pp (nt eterm))
(animate "AppendU")
(pp (nt eterm))

;; [b0]
;;  (Rec algS=>algU)b0 CInitU
;;  ([b1,b2,a3,a4](Rec algU=>algU)a4 a3([a5,a6,a7,a8]CApU a7 a6))
;;  ([b1]CApU CInitU)

; Parsing

(add-program-constant "Test" (py "nat=>list par=>boole"))

(add-computation-rules
 "Test 0(Nil par)"       "True"
 "Test 0(R::x)"          "False"
 "Test(Succ n)(Nil par)" "False"
 "Test n(L::x)"          "Test(Succ n)x"
 "Test(Succ n)(R::x)"    "Test n x")

; We prove totality of test.

(pp (rename-variables (term-to-totality-formula (pt "Test"))))

; allnc n^(TotalNat n^ -> allnc x^(TotalList x^ -> TotalBoole(Test n^ x^)))

; "TestTotal"
(set-goal (term-to-totality-formula (pt "Test")))
(assert (pf
 "allnc x^(TotalList x^ -> allnc n^(TotalNat n^ -> TotalBoole(Test n^ x^)))"))
 (assume "x^" "Tx")
 (elim "Tx")
 (assume "n^" "Tn")
 (elim "Tn")
 (use "TotalBooleTrue")
 (assume "n^1" "Useless1" "Useless2")
 (use "TotalBooleFalse")
 (assume "par^" "x^1" "Tpar")
 (elim "Tpar")
 (assume "Tx1" "IHx1" "n^" "Tn")
 (ng #t)
 (use "IHx1")
 (use "TotalNatSucc")
 (use "Tn")
 (assume "x^1" "IHx1" "n^" "Tn")
 (elim "Tn")
 (use "TotalBooleFalse")
 (assume "n^1" "Tn1" "Useless")
 (ng #t)
 (use "IHx1")
 (use "Tn1")
(assume "TestTotalAux" "n^" "Tn" "x^" "Tx")
(use "TestTotalAux")
(use "Tx")
(use "Tn")
; Proof finished.
(save "TestTotal")


; "TestProp"
(set-goal (pf "all x,y,n,m(Test n x -> Test m y -> Test(n+m)(x++y))"))
(ind)
(ind)
(cases)
(cases)
(auto)
(ng)
(cases)
(assume "y" "IHy")
(ng)
(assume "n" "m" "Hyp1" "Hyp2")
(use-with "IHy" (pt "n") (pt "Succ m") "Hyp1" "Hyp2")
(assume "y" "IHy" "n")
(cases)
(assume "Hyp1" "Absurd")
(use "Efq")
(use "Absurd")
(ng)
(use "IHy")

(cases)
(assume "x" "IHx")
(ng)
(assume "y" "n" "m" "Hyp1" "Hyp2")
(use-with "IHx" (pt "y") (pt "Succ n") (pt "m") "Hyp1" "Hyp2")
(assume "x" "IHx" "y")
(cases)
(assume "m" "Absurd" "Hyp1")
(use "Efq")
(use "Absurd")
(use "IHx")
; Proof finished.
(save "TestProp")

; "Sound"
(set-goal (pf "allnc u(U u -> Test 0 u)"))
(assume "u" "IdHyp")
(elim "IdHyp")
(use "Truth-Axiom")
(assume "x" "y" "U x" "U y" "Test 0 x" "Test 0 y")
(use-with "TestProp" (pt "x") (pt "L::y++R:") (pt "0") (pt "0")
	  "Test 0 x" "?")
(ng)
(use-with "TestProp" (pt "y") (pt "R:") (pt "0") (pt "1")
	  "Test 0 y" "Truth-Axiom")
; Proof finished.
(save "Sound")

; Now for completeness.

; Inductively define a predicate State by clauses
; "InitState": State 0(Nil par)
; "ApState":   allnc n,x,s(S s -> State n x -> State(Succ n)(x++s++L:))

(add-ids
 (list (list "State" (make-arity (py "nat") (py "list par")) "algState"))
 '("State 0(Nil par)" "InitState")
 '("allnc n,x,s(S s -> State n x -> State(Succ n)(x++s++L:))" "ApState"))

; Shift   (state,         s, L::y) -> (state*(s,L), Nil,            y)
; Reduce  (state *(s1,L), s, R::y) -> (state,       s1++(L::s)++R:, y)
; Finish  (init,          s, Nil)  -> s       

; "Parse"
(set-goal
 (pf "all y allnc n,x(State n x -> allnc s(S s -> Test n y -> S(x++s++y)))"))
(ind)

; Case y=(Nil par)
(assume "n" "x" "IdHypState")
(elim "IdHypState")

; First S clause
(auto)

; Second S clause
(assume "n1" "x1" "s1" "H1" "H2" "H3" "s2" "H4" "Absurd")
(use "Efq")
(use "Absurd")

(cases)
; Case L::y.  Uses ApState and InitS.
(assume "y" "IHy" "n" "x" "State n x" "s" "S s")
(ng)
(assume "Test(Succ n)y")
(use-with "IHy" (pt "Succ n") (pt "x++s++L:") "?" (pt "(Nil par)") "?" "?")
(use "ApState")
(auto)
(use "InitS")
(auto)

; Case R::y
(assume "y" "IHy" "n" "x" "IdHypState")
(elim "IdHypState")

; First S clause
(assume "s" "S s" "Absurd")
(use "Efq")
(use "Absurd")

; Second S clause.  Uses ApS, ParS and equality arguments.
(assume "n1" "x1" "s" "S s" "State n1 x1" "IH" "t" "S t" "Test n1 y")
(ng)
(simp (pf "Equal(x1++s++(L::t)++(R::y))(x1++s++(L::t)++R: ++y)"))
(simp (pf "Equal(x1++s++(L::t))(x1++(s++(L::t)))"))
(simp (pf "Equal(x1++(s++(L::t))++R:)(x1++(s++(L::t)++R:))"))
(use-with "IHy" (pt "n1") (pt "x1") "State n1 x1" (pt "s++(L::t)++R:") "?" "?")
(simp (pf "Equal(s++(L::t)++R:)(s++((L::t)++R:))"))
(use "ApS")
(auto)
(use "ParS")
(auto)
(simp "ListAppdAssoc")
(use "Eq-Refl")
(auto)
(simp "ListAppdAssoc")
(simp "ListAppdAssoc")
(simp "ListAppdAssoc")
(use "Eq-Refl")
(simp "ListAppdAssoc")
(use "Eq-Refl")
(ng)
(use "Eq-Refl")
; Proof finished.
(save "Parse")

; "Complete"
(set-goal (pf "all x(Test 0 x -> S x)"))
(assume "x" "Test 0 x")
(use-with "Parse" (pt "x") (pt "0") (pt "(Nil par)")
	  "InitState" (pt "(Nil par)") "InitS" "Test 0 x")
; Proof finished.
(save "Complete")

; "CompleteSound"
(set-goal (pf "all x ex p((p -> S x) & ((p -> F) -> S x -> F))"))
(assume "x")
(ex-intro (pt "Test 0 x"))
(split)
(use "Complete")
(assume "Test 0 x -> F" "S x")
(use "Test 0 x -> F")
(use "Sound")
(use "SU")
(auto)
; Proof finished.
(save "CompleteSound")

(animate "SU")
(animate "Parse")
(animate "Complete")
(add-var-name "st" (py "algState"))
(add-var-name "f" (py "algState=>algS=>algS"))

(define parser-term
  (nt (proof-to-extracted-term (theorem-name-to-proof "CompleteSound"))))
(pp parser-term)

;; [x0]
;;  Test 0 x0@
;;  (Rec list par=>algState=>algS=>algS)x0([st1,b2][if st1 b2 ([b3,st4]CInitS)])
;;  ([par1,x2,f3,st4,b5]
;;    [if par1
;;      (f3(CApState b5 st4)CInitS)
;;      [if st4 CInitS ([b6,st7]f3 st7(CApS b6(CParS b5)))]])
;;  CInitState 
;;  CInitS

; Experiments.

(pp (nt (mk-term-in-app-form parser-term (pt "L::R:"))))
; True@CApS CInitS(CParS CInitS)

(pp (nt (mk-term-in-app-form parser-term (pt "R::L:"))))
; False@CInitS

(pp (nt (mk-term-in-app-form parser-term (pt "L::R::L::R:"))))
; True@CApS(CApS CInitS(CParS CInitS))(CParS CInitS)

(pp (nt (mk-term-in-app-form parser-term (pt "L::L::R::R:"))))
; True@CApS CInitS(CParS(CApS CInitS(CParS CInitS)))
