;(load "~/minlog/init.scm")

;; Contents
;; 1. A type-1 uniformly continuous function to a type-0 ucf.
;; 2. A type-0 ucf to a type-1 ucf.
;; 3. Applying a type-0 ucf to a type-0 real number.
;; 4. Composing ucfs.
;; 5. Definite integration of a type-0 ucf.
;; 6. Experiments

(set! COMMENT-FLAG #f)
(libload "nat.scm")
(libload "numbers.scm")
(exload "analysis/real.scm")
(set! COMMENT-FLAG #t)

;; 1. A type-1 uniformly continuous function to a type-0 ucf.

(remove-var-name "M") ;will be used as constructor for sd
(remove-token "M")

(add-tvar-name "irr"); irrational function
(add-var-name "f" (py "irr"))
(add-pvar-name "X" (make-arity (py "irr")))

(add-alg "sd" '("L" "sd") '("M" "sd") '("R" "sd"))
(add-program-constant "SDToInt" (py "sd=>int"))
(add-computation-rule (pt "SDToInt L") (pt "IntN 1"))
(add-computation-rule (pt "SDToInt M") (pt "0"))
(add-computation-rule (pt "SDToInt R") (pt "IntP 1"))
(add-totality "sd")

(set-goal (term-to-totality-formula (pt "SDToInt")))
(assume "sd^" "Td")
(elim "Td")
(ng #t)
(use "TotalIntIntNeg")
(use "TotalPosOne")
(ng #t)
(use "TotalIntIntZero")
(ng #t)
(use "TotalIntIntPos")
(use "TotalPosOne")
; Proof finished.
(save "SDToIntTotal")

(remove-var-name "k" "l")
(add-var-name "k" "l" (py "nat"))

(add-program-constant "Out" (py "sd=>irr=>irr"))
(add-program-constant "In" (py "sd=>irr=>irr"))

(remove-var-name "p" "q")
(add-var-name "p" "q" (py "rat"))

(add-program-constant "Sub" (py "irr=>rat=>nat=>rat=>nat=>boole"))

(add-global-assumption
 "AxOutElim"
 "all f^,sd,p,l,q,k(
    (Sub irr)f^ (0#1)Zero(SDToInt sd#2)(Succ Zero) ->
    (Sub irr)((Out irr)sd f^)p l q k ->
    (Sub irr)f^ p l((q+SDToInt sd)/2)(k+1))")

(add-global-assumption
 "AxOutIntro"
 "all f^,sd,p,l,q,k(
    (Sub irr)f^(0#1)Zero(SDToInt sd#2)(Succ Zero) ->
    (Sub irr)f^ p l((q+SDToInt sd)/2)(k+1) ->
    (Sub irr)((Out irr)sd f^) p l q k)")

(add-global-assumption
 "AxInIntro"
 "all f^,sd,p,l,q,k(
    (Sub irr)f^((p+SDToInt sd)/2)(l+1) q k ->
    (Sub irr)((In irr)sd f^) p l q k)")

(add-global-assumption
 "AxUcfInputSucc"
 "all f^,p,l,q,k(
    (Sub irr)f^ p l q k ->
    (Sub irr)f^ p (l+1) q k)")

(add-global-assumption
 "AxUcfLeft"
 "allnc f^ all p,q(q<=(IntN 1#4) ->
                   (Sub irr) f^ p Zero q (PosToNat 2) ->
                   (Sub irr) f^ (0#1) Zero (IntN 1#2) (Succ Zero))")

(add-global-assumption
 "AxUcfMiddle"
 "allnc f^ all p,q((IntN 1#4)<=q -> q<=(1#4) ->
                   (Sub irr)f^ p Zero q (PosToNat 2) ->
                   (Sub irr)f^(0#1)Zero(0#2)(Succ Zero))")

(add-global-assumption
 "AxUcfRight"
 "allnc f^ all p,q((1#4)<=q ->
                   (Sub irr)f^ p Zero q (PosToNat 2) ->
                   (Sub irr)f^(0#1)Zero(1#2)(Succ Zero))")

(add-ids
 (list (list "B" (make-arity (py "nat") (py "nat") (py "irr")) "algB"))
 '("allnc f^(all p(exi q ((Sub irr)f^ p l q k)) -> B l k f^)"
   "InitB"))

(add-algs "algread" '("sd=>alpha=>algread" "Put")
	  '("algread=>algread=>algread=>algread" "Get"))

(add-ids
 (list (list "Read" (make-arity (py "irr")) "algread"))
 '("allnc f^ all sd((Sub irr)f^(0#1)Zero(SDToInt sd#2)(Succ Zero) ->
                    X((Out irr)sd f^) -> Read f^)"
   "InitRead")
 '("allnc f^(Read ((In irr)L f^) -> Read ((In irr)M f^) ->
             Read ((In irr)R f^) -> Read f^)"
   "GenRead"))

(add-program-constant "IdIrr" (py "irr"))

(add-algs "algwrite" '("algwrite" "Stop")
	  '("algread algwrite=>algwrite" "Cont"))

(add-ids
 (list (list "Write" (make-arity (py "irr")) "algwrite"))
 '("Write (IdIrr irr)" "InitWrite")
 '("allnc f^((Read (cterm (f^) Write f^)) f^ -> Write f^)"
   "GenWrite"))

(add-co "Write")

(display-idpc "CoWrite")

(add-global-assumption
 "RatTimesLe2" (pf "allnc a,b1,b2(0<=a -> b1<=b2 -> a*b1 <= a*b2)"))

; "NegOrPos"
(set-goal "all rat(rat<=0 ori 0<=rat)")
(cases)
(cases)
(assume "pos0" "pos1")
(intro 1)
(use "Truth-Axiom")
(assume "pos0")
(intro 0)
(use "Truth-Axiom")
(assume "pos0" "pos1")
(intro 0)
(use "Truth-Axiom")
; Proof finished.
(save "NegOrPos")

; "SplitAtRational"
(set-goal "all a,b(a<=b ori b<=a)")
(assume "a" "b")
(assert "a=a-b+b")
 (ord-field-simp-bwd)
(assume "Eq")
(assert (pf "a-b<=0 ori 0<=a-b"))
 (use "NegOrPos")
(assume "NegOrPos inst")
(elim "NegOrPos inst")
(drop "NegOrPos inst")
(assume "Hneg")
(intro 0)
(assert (pf "(a-b)+b<=0+b"))
 (use "RatPlusLe2")
 (use "Hneg")
 (use "Truth-Axiom")
(assume "H0")
(simp "Eq")
(use "H0")
(assume "Hpos")
(intro 1)
(assert (pf "0+b<=(a-b)+b"))
 (use "RatPlusLe2")
 (use "Hpos")
 (use "Truth-Axiom")
(assume "H0")
(simp "Eq")
(use "H0")
; Proof finished.
(save "SplitAtRational")

; "Standard Split"
(set-goal "all a(a <= (IntN 1#4) ori
      ((IntN 1#4) <= a & a <= (IntP 1#4)) ori (IntP 1#4) <= a)")
(assume "a")
(inst-with-to "SplitAtRational" (pt "a") (pt "IntN 1#4") "at -1#4")
(elim "at -1#4")
(assume "a<=-1#4")
(intro 0)
(use "a<=-1#4")
(assume "-1#4<=a")
(inst-with-to "SplitAtRational" (pt "a") (pt "IntP 1#4") "at 1#4")
(elim "at 1#4")
(assume "a<=1#4")
(intro 1)
(intro 0)
(split)
(use "-1#4<=a")
(use "a<=1#4")
(assume "1#4<=a")
(intro 1)
(intro 1)
(use "1#4<=a")
; proof finished
(save "StandardSplit")

;;Lemma1
;; f[I] sub I_d -> B l k+1 f -> B l k (Out f)
(set-goal "allnc f^ all sd allnc l,k(B l (k+1) f^ -> 
 (Sub irr)f^(0#1)Zero(SDToInt sd#2)(Succ Zero) ->
 B l k((Out irr)sd f^))")
(assume "f^" "sd" "l" "k" "HB1")
(elim "HB1")
(assume "f^1" "H0" "HSub")
(use "InitB")
(assume "p")
(inst-with-to "H0" (pt "p") "H0 inst")
(elim "H0 inst")
(assume "q1" "H1")
(intro 0 (pt "2*q1-SDToInt sd"))
(use "AxOutIntro")
(use "HSub")
(assert "(2*q1-SDToInt sd+SDToInt sd)/2 eqd q1")
 (ord-field-simp-bwd)
(assume "Eq1")
(simp "Eq1")
(use "H1")
(save "Lemma1")

;Lemma2
;; f[I] sub I_d -> C f -> C(Out f)
(set-goal "allnc f^ all sd(all k exi l B l k f^ -> 
 (Sub irr)f^(0#1)Zero(SDToInt sd#2)(Succ Zero) ->
 all k exi l B l k((Out irr)sd f^))")
(assume "f^" "sd" "HC1" "HSub" "k1")
(inst-with-to "HC1" (pt "k1+1") "HC2")
(elim "HC2")
(assume "l1" "HB1")
(intro 0 (pt "l1"))
(use "Lemma1")
(use "HB1")
(use "HSub")
(save "Lemma2")

;;arithmetic on SD
(set-goal "all a,sd(IntN 1<=a -> IntN 1<=(a+SDToInt sd)/2)")
(assume "a" "sd" "-1<=a")
(assert "(IntN 1#1) eqd (1#2)*((IntN 1#1)+(IntN 1#1))")
 (ord-field-simp-bwd)
(assume "Eq1")
(simp "Eq1")
(assert "(a+SDToInt sd)/2 eqd (1#2)*(a+SDToInt sd)")
 (ng #t)
 (ord-field-simp-bwd)
(assume "Eq2")
(simp "Eq2")
(use "RatTimesLe2")
(use "Truth-Axiom")
(use "RatPlusLe2")
(use "-1<=a")
(cases (pt "sd"))
(assume "Useless")
(use "Truth-Axiom")
(assume "Useless")
(use "Truth-Axiom")
(assume "Useless")
(use "Truth-Axiom")
(save "LemmaSDLeft1")

;;arithmetic on SD
(set-goal "all a,sd(a<=1 -> (a+SDToInt sd)/2<=1)")
(assume "a" "sd" "a<=1")
(assert "(1#1) eqd (1#2)*((1#1)+(1#1))")
 (ord-field-simp-bwd)
(assume "Eq1")
(simp "Eq1")
(assert "(a+SDToInt sd)/2 eqd (1#2)*(a+SDToInt sd)")
 (ng #t)
 (ord-field-simp-bwd)
(assume "Eq2")
(simp "Eq2")
(use "RatTimesLe2")
(use "Truth-Axiom")
(use "RatPlusLe2")
(use "a<=1")
(cases (pt "sd"))
(assume "Useless")
(use "Truth-Axiom")
(assume "Useless")
(use "Truth-Axiom")
(assume "Useless")
(use "Truth-Axiom")
(save "LemmaSDRight1")

;;Lemma3
;; B l+1 k f -> B l k (In f)
(set-goal "allnc f^ all sd allnc l,k(B (l+1) k f^ -> 
 B l k((In irr)sd f^))")
(assume "f^" "sd" "l" "k" "HB")
(elim "HB")
(assume "f^1" "H0")
(use "InitB")
(assume "p")
(inst-with-to "H0" (pt "(p+SDToInt sd)/2") "H0 inst")
(elim "H0 inst")
(assume "q" "Sub0")
(intro 0 (pt "q"))
(use "AxInIntro")
(use "Sub0")
(save "Lemma3")

;;AuxLemma4
;; B l k f -> B(l+1)k f
(set-goal "allnc f^ all l,k(B l k f^ -> B (l+1) k f^)")
(assume "f^" "l" "k" "B0")
(elim "B0")
(assume "f^1" "H0")
(intro 0)
(assume "p1")
(inst-with-to "H0" (pt "p1") "H1")
(elim "H1")
(assume "q" "H2")
(intro 0 (pt "q"))
(use "AxUcfInputSucc")
(use "H2")
(save "AuxLemma4")

;;Lemma4
;; C f -> C(In f)
(set-goal "allnc f^ all sd(all k exi l B l k f^ -> 
 all k exi l B l k((In irr)sd f^))")
(assume "f^" "sd" "HB" "k")
(inst-with-to "HB" (pt "k") "HB1")
(elim "HB1")
(assume "l" "H0")
(cases (pt "l"))
(assume "l Zero")
(intro 0 (pt "Zero"))
(use "Lemma3")
(use "AuxLemma4")
(simp "<-" "l Zero")
(use "H0")
(assume "l1" "l Succ")
(intro 0 (pt "l1"))
(use "Lemma3")
(assert "l1+1 = Succ l1")
 (use "Truth-Axiom")
(assume "Eq")
(simp "Eq")
(simp "<-" "l Succ")
(use "H0")
(save "Lemma4")

;;Lemma5
; B 0 2 -> ex sd(f[I] sub I_sd)
(set-goal "allnc f^(B Zero 2 f^ ->
 exi sd((Sub irr)f^ (0#1)Zero(SDToInt sd#2)(Succ Zero)))")
(assume "f^" "B 0 2 f^")
(elim "B 0 2 f^")
(assume "f^1" "H0")
(inst-with-to "H0" (pt "0#1") "H1")
(elim "H1")
(assume "q" "H2")
(inst-with-to "StandardSplit" (pt "q") "SSq")
(elim "SSq")
(assume "q Left")
(intro 0 (pt "L"))
(use "AxUcfLeft" (pt "0#1") (pt "q"))
(use "q Left")
(use "H2")
(assume "q Middle or Right")
(elim "q Middle or Right")
(assume "q Middle")
(intro 0 (pt "M"))
(use "AxUcfMiddle" (pt "0#1") (pt "q"))
(use "q Middle")
(use "q Middle")
(use "H2")
(assume "q Right")
(intro 0 (pt "R"))
(use "AxUcfRight" (pt "0#1") (pt "q"))
(use "q Right")
(use "H2")
(save "Lemma5")

;Lemma 6
;; all l(B l 2 f -> C f -> Read(CoWrite or C)f)
(set-goal "all l allnc f^(B l 2 f^ -> all k exi l B l k f^ ->
           (Read (cterm (f^) CoWrite f^ ori all k exi l B l k f^))f^)")
(ind)
(assume "f^" "B l 2 f" "C f")
(inst-with-to "Lemma5" (pt "f^") "B l 2 f"  "Lemma5 inst")
(elim "Lemma5 inst")
(assume "sd" "Sub0")
(intro 0 (pt "sd"))
(use "Sub0")
(intro 1)
(use "Lemma2")
(use "C f")
(use "Sub0")
(assume "l" "IH" "f^" "B l+1 2 f" "C f")
(intro 1)
(use "IH")
(use "Lemma3")
(use "B l+1 2 f")
(use "Lemma4")
(use "C f")
(use "IH")
(use "Lemma3")
(use "B l+1 2 f")
(use "Lemma4")
(use "C f")
(use "IH")
(use "Lemma3")
(use "B l+1 2 f")
(use "Lemma4")
(use "C f")
(save "Lemma6")

;PropA
;; C f -> CoWrite f
(set-goal "allnc f^(all k exi l B l k f^ -> CoWrite f^)")
(assume "f^" "H0")
(coind "H0")
(assume "f^1" "C f")
(intro 1)
(intro 0 (pt "f^1"))
(split)
(inst-with-to "C f" (pt "PosToNat 2") "C f inst")
(elim "C f inst")
(assume "l" "B l 2 f^1")
(use "Lemma6" (pt "l"))
(use "B l 2 f^1")
(use "C f")
(use "InitEqD")
(save "PropA")

(define eterm-a
  (proof-to-extracted-term (theorem-name-to-proof "PropA")))

(define neterm-a (nt eterm-a))

(pp neterm-a)
;; [(nat=>nat yprod algB)_0]
;;  (CoRec (nat=>nat yprod algB)=>algwrite)(nat=>nat yprod algB)_0
;;  ([(nat=>nat yprod algB)_1]
;;    Inr[if ((nat=>nat yprod algB)_1(Succ(Succ Zero)))
;;         ([n2,algB3]cLemmaSix n2 algB3(nat=>nat yprod algB)_1)])

;; 2. A type-0 ucf to a type-1 ucf.
(add-global-assumption
 "AxUcfId"
 "all p,l (Sub irr)(IdIrr irr)p l p l")

(add-global-assumption
 "AxInElim"
 "allnc f^,sd,p,l,q,k(
    (Sub irr)((In irr)sd f^)p l q k ->
    (Sub irr)f^((p+SDToInt sd)/2)(l+1) q k)")

(add-global-assumption
 "AxUcfBound"
 "allnc f^ all p,l((Sub irr)f^ p l 0 Zero)")

;;AuxLemma 8
;; f[I(p,l)] sub I(q,k) -> f[I(p,l+l')] sub I(q,k) for arbitrary l'
(set-goal "allnc f^ all p,l,q,k,l1((Sub irr)f^ p l q k ->
  (Sub irr)f^ p (l+l1) q k)")
(assume "f^" "p" "l" "q" "k")
(ind)
(assume "H0")
(use "H0")
(assume "l1" "IH" "Sub1")
(use "AxUcfInputSucc")
(use "IH")
(use "Sub1")
(save "AuxLemma8")

;;LemmaNatProp
;; n0<=n1 -> ex m (n0+m = n1)
(set-goal "all n0,n1(n0<=n1 -> exi m n0+m eqd n1)")
(ind)
(assume "n" "H0")
(intro 0 (pt "n"))
(use "InitEqD")
(assume "n" "IH1")
(cases)
(assume "Falsity")
(use "Efq")
(use "Falsity")
(assume "n1" "n1<=n0")
(inst-with-to "IH1" (pt "n1") "n1<=n0" "IH1 inst")
(elim "IH1 inst")
(assume "m1" "Eq")
(intro 0 (pt "m1"))
(simp "<-" "Eq")
(use "InitEqD")
(save "LemmaNatProp")

;Lemma RatMinusLe2
;; a1<=a2 -> a4<=a3 -> a1-a3<=a2-a4
(set-goal "all a1,a2,a3,a4(a1<=a2 -> a4<=a3 -> a1-a3<=a2-a4)")
(assume "a1" "a2" "a3" "a4" "Ieq1" "Ieq2")
(assert "a1-a3 = a1+a4+(0-a3)+(0-a4)")
 (ord-field-simp-bwd)
(assume "Eq1")
(assert "a2-a4 = a2+a3+(0-a3)+(0-a4)")
 (ord-field-simp-bwd)
(assume "Eq2")
(simp "Eq1")
(simp "Eq2")
(use "RatPlusLe2")
(use "RatPlusLe2")
(use "RatPlusLe2")
(use "Ieq1")
(use "Ieq2")
(use "Truth-Axiom")
(use "Truth-Axiom")
(save "RatMinusLe2")

;; arithmetic on SD
(set-goal "all a,sd((SDToInt sd#2)+(IntN 1#2)<=a ->
                    IntN 1<=2*a-(SDToInt sd))")
(assume "a" "sd")
(assume "H0")
(assert "IntN 1 eqd (SDToInt sd+IntN 1)-SDToInt sd")
 (ord-field-simp-bwd)
(assume "Eq1")
(simp "Eq1")
(use-with "RatMinusLe2" (pt "(SDToInt sd+IntN 1)#1") (pt "2*a")
	  (pt "SDToInt sd#1") (pt "SDToInt sd#1") "?" "Truth-Axiom")
(assert "(SDToInt sd+IntN 1)#1 eqd 2*((SDToInt sd#2)+(IntN 1#2))")
 (ord-field-simp-bwd)
(assume "Eq2")
(simp "Eq2")
(use "RatTimesLe2")
(use "Truth-Axiom")
(use "H0")
(save "LemmaSDLeft2")

;; arithmetic on SD
(set-goal "all a,sd(a<=(SDToInt sd#2)+(IntP 1#2) -> 2*a-(SDToInt sd)<=1)")
(assume "a" "sd")
(assume "H0")
(assert "IntP 1 eqd (SDToInt sd+IntP 1)-SDToInt sd")
 (ord-field-simp-bwd)
(assume "Eq1")
(simp "Eq1")
(use-with "RatMinusLe2" (pt "2*a") (pt "(SDToInt sd+IntP 1)#1")
	  (pt "SDToInt sd#1") (pt "SDToInt sd#1") "?" "Truth-Axiom")
(assert "(SDToInt sd+IntP 1)#1 eqd 2*((SDToInt sd#2)+(IntP 1#2))")
 (ord-field-simp-bwd)
(assume "Eq2")
(simp "Eq2")
(use "RatTimesLe2")
(use "Truth-Axiom")
(use "H0")
(save "LemmaSDRight2")

;Lemma 8
;; B l0 k (In L f) -> B l1 k (In M f) -> B l2 k (In R f) ->
;; B (1+l0 max l1 max l2) k f
(set-goal "allnc f^ all l0,l1,l2,k(B l0 k((In irr)L f^) -> 
  B l1 k((In irr)M f^) ->  B l2 k((In irr)R f^) ->
  B(Succ(l0 max l1 max l2))k f^)")
(assume "f^" "l0" "l1" "l2" "k" "HBL" "HBM" "HBR")
(intro 0)
(assume "p")
(inst-with-to "StandardSplit" (pt "p") "SSp")
(elim "SSp")
(assume "p Left")
(inversion "HBL")
(assume "f^0" "H0" "Useless l" "Useless k" "Eq")
(inst-with-to "H0" (pt "2*p-SDToInt L") "H1")
(elim "H1")
(assume "q" "HSub")
(intro 0 (pt "q"))
(assert "p eqd ((2*p-SDToInt L)+SDToInt L)/2")
 (ord-field-simp-bwd)
(assume "Heq")
(simp "Heq")
(use-with "AxInElim" (pt "f^") (pt "L") (pt "2*p-SDToInt L")
	  (pt "l0 max l1 max l2") (pt "q") (pt "k") "?")
(simp "Eq")
(assert "l0<=l0 max l1 max l2")
 (use "NatLeTrans" (pt "l0 max l1"))
 (use "NatMaxUB1")
 (use "NatMaxUB1")
(assume "HLe")
(inst-with-to "LemmaNatProp" (pt "l0") (pt "l0 max l1 max l2") "HLe" "Hex")
(elim "Hex")
(assume "m" "Eqmax")
(simp "<-" "Eqmax")
(use "AuxLemma8")
(use "HSub")
;
(assume "p Middle or Right")
(elim "p Middle or Right")
(assume "p Middle")
(inversion "HBM")
(assume "f^0" "H0" "Useless l" "Useless k" "Eq")
(inst-with-to "H0" (pt "2*p-SDToInt M") "H1")
(elim "H1")
(assume "q" "HSub")
(intro 0 (pt "q"))
(assert "p eqd ((2*p-SDToInt M)+SDToInt M)/2")
 (ord-field-simp-bwd)
(assume "Heq")
(simp "Heq")
(use-with "AxInElim" (pt "f^") (pt "M") (pt "2*p-SDToInt M")
	  (pt "l0 max l1 max l2") (pt "q") (pt "k") "?")
(simp "Eq")
(assert "l1<=l0 max l1 max l2")
 (use "NatLeTrans" (pt "l0 max l1"))
 (use "NatMaxUB2")
 (use "NatMaxUB1")
(assume "HLe")
(inst-with-to "LemmaNatProp" (pt "l1") (pt "l0 max l1 max l2") "HLe" "Hex")
(elim "Hex")
(assume "m" "Eqmax")
(simp "<-" "Eqmax")
(use "AuxLemma8")
(use "HSub")
;
(assume "p Right")
(inversion "HBR")
(assume "f^0" "H0" "Useless l" "Useless k" "Eq")
(inst-with-to "H0" (pt "2*p-SDToInt R") "H1")
(elim "H1")
(assume "q" "HSub")
(intro 0 (pt "q"))
(assert "p eqd ((2*p-SDToInt R)+SDToInt R)/2")
 (ord-field-simp-bwd)
(assume "Heq")
(simp "Heq")
(use-with "AxInElim" (pt "f^") (pt "R") (pt "2*p-SDToInt R")
	  (pt "l0 max l1 max l2") (pt "q") (pt "k") "?")
(simp "Eq")
(assert "l2<=l0 max l1 max l2")
 (use "NatMaxUB2")
(assume "HLe")
(inst-with-to "LemmaNatProp" (pt "l2") (pt "l0 max l1 max l2") "HLe" "Hex")
(elim "Hex")
(assume "m" "Eqmax")
(simp "<-" "Eqmax")
(use "AuxLemma8")
(use "HSub")
(save "Lemma8")

;Lemma 9
; B l k (Out f) -> B l (k+1) f
(set-goal "allnc f^ all sd,l,k(
 B l k((Out irr)sd f^) -> 
 (Sub irr)f^(0#1)Zero(SDToInt sd#2)(Succ Zero) ->
 B l (k+1) f^)")
(assume "f^" "sd" "l" "k" "HB1")
(inversion "HB1")
(assume "f^1" "H0" "Useless l" "Useless k" "Eq" "HSub")
(use "InitB")
(assume "p")
(inst-with-to "H0" (pt "p") "H0 inst")
(elim "H0 inst")
(assume "q1" "H1")
(intro 0 (pt "(q1+SDToInt sd)/2"))
(use "AxOutElim")
(use "HSub")
(simp "Eq")
(use "H1")
(save "Lemma9")

;;PropB
;; CoWrite f -> C f
(set-goal "allnc f^(CoWrite f^ -> all k exi l B l k f^)")
(cut "all k allnc f^(CoWrite f^ -> exi l B l k f^)")
 (assume "Hcut" "f^" "CoW f" "k")
 (use-with "Hcut" (pt "k") (pt "f^") "CoW f")
(ind)
;l=0
(assume "f^" "CoWrite f")
(intro 0 (pt "Zero"))
(intro 0)
(assume "p")
(intro 0 (pt "0#1"))
(use "AxUcfBound")
;l -> l+1
(assume "k" "IH" "f^" "CoWrite f")
(inst-with-to "CoWriteClause" (pt "f^") "CoWrite f" "HClause")
(elim "HClause")
;; IdIrr
(assume "Hid")
(intro 0 (pt "Succ k"))
(intro 0)
(assume "p")
(intro 0 (pt "p"))
(simp "Hid")
(use "AxUcfId")
;; end
;; Read f
(assume "HReadEx")
(elim "HReadEx")
(assume "f^0" "Hand")
(elim "Hand")
(assume "Read f0" "f=f0")
(simp "f=f0")
(elim "Read f0")
;ind
; Read1
;; ?_29:allnc f^ 
;;       all sd(
;;        (Sub irr)f^ 0 Zero(SDToInt sd#2)(Succ Zero) -> 
;;        CoWrite((Out irr)sd f^) -> exd l B l(Succ k)f^)
(assume "f^1" "sd" "Sub1" "CoWrite Outf1")
(inst-with-to "IH" (pt "(Out irr)sd f^1") "CoWrite Outf1" "HexB")
(elim "HexB")
(assume "l1" "HB1")
(intro 0 (pt "l1"))
(use "Lemma9" (pt "sd"))
(use "HB1")
(use "Sub1")
; Read2
(assume "f^2" "HReadL" "IHL" "HReadM" "IHM" "HReadR" "IHR")
(elim "IHL")
(assume "l0" "HBL")
(elim "IHM")
(assume "l1" "HBM")
(elim "IHR")
(assume "l2" "HBR")
(intro 0 (pt "Succ(l0 max l1 max l2)"))
(use "Lemma8")
(use "HBL")
(use "HBM")
(use "HBR")
(save "PropB")

(define eterm-b (proof-to-extracted-term (theorem-name-to-proof "PropB")))
(define neterm-b (nt eterm-b))
(pp neterm-b)
;; [algwrite0,n1]
;;  (Rec nat=>algwrite=>nat yprod algB)n1([algwrite2]Zero pair CInitB([a3]0))
;;  ([n2,(algwrite=>nat yprod algB)_3,algwrite4]
;;    [if (des algwrite4)
;;      (Succ n2 pair CInitB([a5]a5))
;;      ([(algread algwrite)_5]
;;       (Rec algread algwrite=>nat yprod algB)(algread algwrite)_5
;;       ([sd6,algwrite7]
;;         [if ((algwrite=>nat yprod algB)_3 algwrite7)
;;           ([n8,algB9]n8 pair cLemmaNine sd6 n8 n2 algB9)])
;;       ([(algread algwrite)_6,(nat yprod algB)_7,(algread algwrite)_8,(nat yprod algB)_9,(algread algwrite)_10,(nat yprod algB)_11]
;;         [if (nat yprod algB)_7
;;           ([n12,algB13]
;;            [if (nat yprod algB)_9
;;              ([n14,algB15]
;;               [if (nat yprod algB)_11
;;                 ([n16,algB17]
;;                  Succ(n12 max n14 max n16)pair 
;;                  cLemmaEight n12 n14 n16(Succ n2)algB13 algB15 algB17)])])]))])
;;  algwrite0

;; 3. Applying a type-0 ucf to a type-0 real number.
(add-alg "iv" '("II" "iv") '("C" "sd=>iv=>iv"))
(add-tvar-name "r");; abstract real numbers
(remove-var-name "x")
(remove-var-name "y" "z")
(add-var-name "x" (py "r"))
(add-var-name "y" "z" (py "r"))

(add-program-constant "Z" (py "r")) ; zero
(add-program-constant "Av" (py "r=>sd=>r")) ;average
(add-program-constant "Va" (py "r=>sd=>r")) ;inverse of average
(add-program-constant "Elem" (py "r=>rat=>nat=>boole"))

(add-ids (list (list "I" (make-arity (py "r")) "iv"))
	 '("I(Z r)" "InitI")
	 '("allnc x^ all sd(I x^ -> I((Av r)x^ sd))" "GenI"))

(add-co "I")

(add-program-constant "App" (py "irr=>r=>r"))

(add-global-assumption
 "AxAvVaIdent"
 "all x^,sd((Elem r)x^(SDToInt sd#2)(Succ Zero) ->
            x^ eqd(Av r)((Va r)x^ sd)sd)")

(add-global-assumption
 "AxVaAvIdent"
 "all x^,sd(x^ eqd(Va r)((Av r)x^ sd)sd)")

(add-global-assumption
 "AxAvZero"
 "(Av r)(Z r)M eqd (Z r)")

(add-global-assumption
 "AxAppId"
 "allnc x^((App irr r)(IdIrr irr)x^ eqd x^)")

(add-global-assumption
 "AxAppSubElem"
 "allnc f^,x^ all q,k((Sub irr)f^ 0 Zero q k ->
                     (Elem r)((App irr r)f^ x^)q k)")

(add-global-assumption
 "AxVaOut"
 "allnc f^,x^ all sd((Sub irr)f^ 0 Zero(SDToInt sd#2)(Succ Zero) ->
    (Va r)((App irr r)f^ x^)sd eqd (App irr r)((Out irr)sd f^)x^)")

(add-global-assumption
 "AxAvIn"
 "allnc f^,x^ all sd((App irr r)f^((Av r)x^ sd)eqd
                     (App irr r)((In irr)sd f^)x^)")

;;Lemma apply
(set-goal "allnc f^0((Read (cterm (f^) CoWrite f^))f^0 -> 
      allnc x^0(CoI x^0 ->
        (App irr r)f^0 x^0 eqd(Z r) orr 
        exr y^ 
         ex sd(
          (CoI y^ ord 
           exr f^1,x^1(y^ eqd(App irr r)f^1 x^1 &
                       CoWrite f^1 & CoI x^1)) andl
          (App irr r)f^0 x^0 eqd(Av r)y^ sd)))")
(assume "f^0" "Read f0")
(elim "Read f0")
;; First step case
(assume "f^1" "sd" "f[I] Sub I_sd" "CoWrite(Out sd f)")
(assume "x^0" "CoI x0")
(intro 1)
(intro 0 (pt "(App irr r)((Out irr) sd f^1)x^0"))
(ex-intro (pt "sd"))
(split)
(intro 1)
(intro 0 (pt "(Out irr)sd f^1"))
(intro 0 (pt "x^0"))
(split)
(use "InitEqD")
(split)
(use "CoWrite(Out sd f)")
(use "CoI x0")
(simp "<-" "AxVaOut")
(simp "<-" "AxAvVaIdent")
(use "InitEqD")
(use "AxAppSubElem")
(use "f[I] Sub I_sd")
(use "f[I] Sub I_sd")
;; Second step case
(assume "f^" "HypRL" "IHL" "HypRM" "IHM" "HypRR" "IHR")
(assume "x^0" "CoI x0")
(inst-with-to "CoIClause" (pt "x^0") "CoI x0" "HCases CoI x0")
(elim "HCases CoI x0")
;; Left case
(assume "x0 eqd Zero")
(inst-with-to "IHM" (pt "x^0") "CoI x0" "IHM inst")
(assert "(App irr r)f^ x^0 eqd (App irr r)((In irr)M f^)x^0")
 (simp "x0 eqd Zero")
 (simp "<-" "AxAvIn")
 (simp "AxAvZero")
 (use "InitEqD")
(assume "Heq")
(simp "Heq")
(use "IHM inst")
;; Right case
(assume "Hexex")
(elim "Hexex")
(assume "x^1" "Hex")
(ex-elim "Hex")
(assume "sd1" "H0")
(inst-with-to "H0" 'left "CoI x1")
(cases (pt "sd1"))
;; three subcases: L
(assume "CaseL")
(inst-with-to "IHL" (pt "x^1") "CoI x1" "IHL inst")
(elim "H0")
(assume "H0L" "H0R")
(simp "H0R" 'right)
(simp "CaseL")
(simp "AxAvIn")
(use "IHL inst")
;; three subcases: M
(assume "CaseM")
(inst-with-to "IHM" (pt "x^1") "CoI x1" "IHM inst")
(elim "H0")
(assume "H0L" "H0R")
(simp "H0R" 'right)
(simp "CaseM")
(simp "AxAvIn")
(use "IHM inst")
;; three subcases: R
(assume "CaseR")
(inst-with-to "IHR" (pt "x^1") "CoI x1" "IHR inst")
(elim "H0")
(assume "H0L" "H0R")
(simp "H0R" 'right)
(simp "CaseR")
(simp "AxAvIn")
(use "IHR inst")
(save "LemmaApply")

;; Apply
(set-goal "allnc f^,x^(CoWrite f^ -> CoI x^ -> CoI((App irr r)f^ x^))")
(assume "f^" "x^" "CoW f" "CoI x")
;Preparing our competitor
(assert "exnci f^1,x^1((App irr r)f^ x^ eqd (App irr r)f^1 x^1 &
                        CoWrite f^1 & CoI x^1)")
 (intro 0 (pt "f^"))
 (intro 0 (pt "x^"))
 (split)
 (use "InitEqD")
 (split)
 (use "CoW f")
 (use "CoI x")
;Assuming our competitor
(assume "Q z")
(coind "Q z")
(assume "z^0" "Q z0")
(elim "Q z0")
(assume "f^0" "Hex")
(elim "Hex")
(assume "x^0" "Hand")
(inst-with-to "Hand" 'right 'left "CoW f0")
(inst-with-to "Hand" 'right 'right "CoI x0")
(inst-with-to "CoWriteClause" (pt "f^0") "CoW f0" "HCases")
(elim "HCases")
;;case f0 = Id
(assume "f0 eqd Id")
(inst-with-to "CoIClause" (pt "x^0") "CoI x0" "HCases x0")
(elim "HCases x0")
(assume "x0 eqd Z")
(intro 0)
(simp "Hand")
(simp "f0 eqd Id")
(simp "x0 eqd Z")
(use "AxAppId")
(assume "Hexrex")
(intro 1)
(elim "Hexrex")
(assume "x^1" "Hex 2")
(intro 0 (pt "x^1"))
(ex-elim "Hex 2")
(assume "sd" "Heqd")
(ex-intro (pt "sd"))
(split)
(intro 0)
(use "Heqd")
(simp "Hand")
(simp "f0 eqd Id")
(elim "Heqd")
(assume "HeqdL" "HeqdR")
(simp "HeqdR")
(use "AxAppId")
;done
;right case
; ?_27:exr f^(f^0 eqd f^ & (Read (cterm (f^1) CoWrite f^1))f^) -> 
;      z^0 eqd(Z r) orr 
;      exr x^ 
;       ex sd(
;        z^0 eqd(Av r)x^ sd & 
;        (CoI x^ ord 
;         exr f^,x^0(x^ eqd(App irr r)f^ x^0 & CoWrite f^ & CoI x^0)))
(assume "HypRead")
(assert "(Read (cterm (f^1) CoWrite f^1))f^0")
 (elim "HypRead")
 (assume "f^1" "H1")
 (elim "H1")
 (assume "H1L" "H1R")
 (simp "H1R")
 (use "H1")
(assume "HRead")
(assert "(App irr r)f^0 x^0 eqd(Z r) orr 
      exr x^ 
       ex sd(
        (CoI x^ ord 
         exr f^,x^0(x^ eqd(App irr r)f^ x^0 &
                    CoWrite f^ & CoI x^0)) andl
        (App irr r)f^0 x^0 eqd(Av r)x^ sd)")
 (use "LemmaApply")
 (use "HRead")
 (use "CoI x0")
(assume "H2")
(elim "H2")
(assume "Hleft")
(intro 0)
(simp "Hand")
(use "Hleft")
(assume "Hright")
(intro 1)
(simp "Hand")
(use "Hright")
(save "PropApply")

(define eterm-apply
  (proof-to-extracted-term (theorem-name-to-proof "PropApply")))
(define neterm-apply (nt eterm-apply))

(pp neterm-apply)
;; [algwrite0,iv1]
;;  (CoRec algwrite@@iv=>iv)(algwrite0@iv1)
;;  ([(algwrite@@iv)_2]
;;    [if (des left(algwrite@@iv)_2)
;;      [if (des right(algwrite@@iv)_2)
;;       (DummyL sd@@(iv ysum algwrite@@iv))
;;       ([(sd@@iv)_3]Inr(left(sd@@iv)_3@(InL iv algwrite@@iv)right(sd@@iv)_3))]
;;      ([(algread algwrite)_3]
;;       [if (cLemmaApply(algread algwrite)_3 right(algwrite@@iv)_2)
;;         (DummyL sd@@(iv ysum algwrite@@iv))
;;         (InrUysum sd@@(iv ysum algwrite@@iv))])])

;; 4. Composing ucfs.
(remove-var-name "j")
(add-var-name "j" (py "nat"))
(add-program-constant "Cmp" (py "irr=>irr=>irr"))

(add-global-assumption
 "AxUcfInputIn"
 "allnc f^,p,l all sd((Sub irr)f^ 0 Zero p l ->
                      (Sub irr)((In irr)sd f^)0 Zero p l)")

(add-global-assumption
 "AxIdIn"
 "all sd((Sub irr)((In irr)sd(IdIrr irr))
         (0#1)Zero(SDToInt sd#2)(Succ Zero))")

(add-global-assumption
 "AxCompIdL"
 "allnc f^((Cmp irr)(IdIrr irr)f^ eqd f^)")

(add-global-assumption
 "AxCompIdR"
 "allnc f^((Cmp irr)f^(IdIrr irr) eqd f^)")

(add-global-assumption
 "AxCompBound"
 "allnc f^1,f^2 all sd((Sub irr)f^1(0#1)Zero(SDToInt sd#2)(Succ Zero) ->
  (Sub irr)((Cmp irr)f^1 f^2)(0#1)Zero(SDToInt sd#2)(Succ Zero))")

(add-global-assumption
 "AxOutIdIn"
 "all sd((Out irr)sd((In irr)sd(IdIrr irr)) eqd (IdIrr irr))")

(add-global-assumption
 "AxInOutIdent"
 "allnc f^1,f^2 all sd((Sub irr)f^2(0#1)Zero(SDToInt sd#2)(Succ Zero) ->
   (Cmp irr)f^1 f^2 eqd(Cmp irr)((In irr)sd f^1)((Out irr)sd f^2))")

(add-global-assumption
 "AxAssocOutIn"
 "allnc f^ all sd1,sd2((Sub irr)f^ 0 Zero(SDToInt sd1#2)(Succ Zero) ->
          (Out irr)sd1((In irr)sd2 f^)eqd(In irr)sd2((Out irr)sd1 f^))")

(add-global-assumption
 "AxAssocCompIn"
 "allnc f^1,f^2,sd (In irr)sd((Cmp irr)f^1 f^2) eqd
                   (Cmp irr)f^1((In irr)sd f^2)")

(add-global-assumption
 "AxAssocOutComp"
 "allnc f^1,f^2,sd((Sub irr)f^1(0#1)Zero(SDToInt sd#2)(Succ Zero) ->
  (Cmp irr)((Out irr)sd f^1)f^2 eqd(Out irr)sd((Cmp irr)f^1 f^2))")

;; CoWrite f -> CoWrite (In f)
(set-goal "allnc f^ all sd(CoWrite f^ -> CoWrite((In irr)sd f^))")
(assume "f^" "sd" "CoWrite f")
(assert "exr f^1(CoWrite f^1 andl (In irr)sd f^ eqd (In irr)sd f^1)")
(intro 0 (pt "f^"))
 (split)
 (use "CoWrite f")
 (use "InitEqD")
(assume "P f")
(coind "P f")
;
(assume "f^1" "P f1")
(by-assume-with "P f1" "f^2" "Hyp1")
(inst-with-to "Hyp1" 'left "CoWrite f2")
(inst-with-to "Hyp1" 'right "Eq")
(simp "Eq")
(inst-with-to "CoWriteClause" (pt "f^2") "CoWrite f2" "Case f2")
(elim "Case f2")
;left
(assume "f2 eqd Id")
(intro 1)
(simp "f2 eqd Id")
(intro 0 (pt "(In irr)sd(IdIrr irr)"))
(split)
(intro 0 (pt "sd"))
(use "AxIdIn")
(simp "AxOutIdIn")
(intro 0)
(simp "<-" "f2 eqd Id")
(use "CoWrite f2")
(use "InitEqD")
;right
(assume "Hyp2")
(by-assume-with "Hyp2" "f^3" "Read f3 and eq")
(intro 1)
(inst-with-to "Read f3 and eq" 'left "Read f3")
(intro 0 (pt "(In irr)sd f^2"))
(split)
(elim "Read f3 and eq")
(assume "Read f3 2" "Heq")
(simp "Heq")
(elim "Read f3")
(assume "f^4" "sd1" "f[I] sub I_sd1" "CoWrite out f")
(intro 0 (pt "sd1"))
(use "AxUcfInputIn")
(use "f[I] sub I_sd1")
(intro 1)
(intro 0 (pt "(Out irr)sd1 f^4"))
(split)
(use "CoWrite out f")
(use "AxAssocOutIn")
(use "f[I] sub I_sd1")
;
(assume "f^4" "Read L" "IH L" "Read M" "IH M" "Read R" "IH R")
(cases (pt "sd"))
(assume "Case L")
(elim "Read L")
(assume "f^5" "sd1" "f5[I] sub I_sd1" "CoWrite out f5")
(intro 0 (pt "sd1"))
(use "f5[I] sub I_sd1")
(intro 0)
(use "CoWrite out f5")
(assume "f^5" "Sub Read L" "Sub IH L" "Sub Read M"
	"Sub IH M" "Sub Read R" "Sub IH R")
(intro 1)
(use "Sub IH L")
(use "Sub IH M")
(use "Sub IH R")
;
(assume "Case M")
(elim "Read M")
(assume "f^5" "sd1" "f5[I] sub I_sd1" "CoWrite out f5")
(intro 0 (pt "sd1"))
(use "f5[I] sub I_sd1")
(intro 0)
(use "CoWrite out f5")
(assume "f^5" "Sub Read L" "Sub IH L" "Sub Read M" "Sub IH M"
	"Sub Read R" "Sub IH R")
(intro 1)
(use "Sub IH L")
(use "Sub IH M")
(use "Sub IH R")
;
(assume "Case R")
(elim "Read R")
(assume "f^5" "sd1" "f5[I] sub I_sd1" "CoWrite out f5")
(intro 0 (pt "sd1"))
(use "f5[I] sub I_sd1")
(intro 0)
(use "CoWrite out f5")
(assume "f^5" "Sub Read L" "Sub IH L" "Sub Read M" "Sub IH M"
	"Sub Read R" "Sub IH R")
(intro 1)
(use "Sub IH L")
(use "Sub IH M")
(use "Sub IH R")
;
(use "InitEqD")
(save "Lemma10")

;;Cowrite f -> CoWrite g -> Cowrite (f g)
(set-goal "allnc f^1,f^2(CoWrite f^1 -> CoWrite f^2 ->
                         CoWrite((Cmp irr)f^1 f^2))")
(assume "f^1" "f^2" "CoWrite f1" "CoWrite f2")
(assert "exr f^3,f^4(CoWrite f^3 andd CoWrite f^4 andl
                     (Cmp irr)f^1 f^2 eqd (Cmp irr)f^3 f^4)")
 (intro 0 (pt "f^1"))
 (intro 0 (pt "f^2"))
 (split)
 (use "CoWrite f1")
 (split)
 (use "CoWrite f2")
 (use "InitEqD")
(assume "P(f1 o f2)")
;
(coind "P(f1 o f2)")
(assume "f^3" "P f3")
(by-assume-with "P f3" "f^4" "P f3 2")
(by-assume-with "P f3 2" "f^5" "Hyp")
(inst-with-to "Hyp" 'left "CoWrite f4")
(inst-with-to "Hyp" 'right 'left "CoWrite f5")
(inst-with-to "Hyp" 'right 'right "Eq")
(inst-with-to "CoWriteClause" (pt "f^4") "CoWrite f4" "Clause f4")
(inst-with-to "CoWriteClause" (pt "f^5") "CoWrite f5" "Clause f5")
(simp "Eq")
;Case id f4 or R f4
(elim "Clause f4")
(assume "f4 eqd Id")
(simp "f4 eqd Id")
(simp "AxCompIdL")
;Case id f5 or R f5
(elim "Clause f5")
; id id
(assume "f5 eqd Id")
(simp "f5 eqd Id")
(intro 0)
(use "InitEqD")
; id Read
(assume "Ex Read f5")
(by-assume-with "Ex Read f5" "f^6" "Read f5")
(inst-with-to "Read f5" 'left "Read f6")
(elim "Read f5")
(assume "Read f6 2" "Heq")
(simp "Heq")
(intro 1)
(intro 0 (pt "f^6"))
(split)
(elim "Read f6")
(assume "f^7" "sd" "f[I] sub I_d" "CoWrite outd f")
(intro 0 (pt "sd"))
(use "f[I] sub I_d")
(intro 0)
(use "CoWrite outd f")
(assume "f^7" "Read L" "IH L" "Read M" "IH M" "Read R" "IH R")
(intro 1)
(use "IH L")
(use "IH M")
(use "IH R")
(use "InitEqD")
;
(assume "Ex Read f4")
(by-assume-with "Ex Read f4" "f^6" "Read f6")
(elim "Read f6")
(assume "Read f6 2" "Heq")
(simp "Heq")
(elim "Clause f5")
; R id
(assume "f5 eqd Id")
(simp "f5 eqd Id")
(simp "AxCompIdR")
(intro 1)
(intro 0 (pt "f^6"))
(split)
(inst-with-to "Read f6" 'left "Read f6 3")
(elim "Read f6 3")
(assume "f^7" "sd" "f[I] sub I_d" "CoWrite outd f")
(intro 0 (pt "sd"))
(use "f[I] sub I_d")
(intro 0)
(use "CoWrite outd f")
(assume "f^7" "Read L" "IH L" "Read M" "IH M" "Read R" "IH R")
(intro 1)
(use "IH L")
(use "IH M")
(use "IH R")
(use "InitEqD")
; R R
(assume "Ex Read f5")
(by-assume-with "Ex Read f5" "f^7" "Read f7")
(elim "Read f7")
(assume "Read f7 2" "Heq2")
(simp "Heq2")
(inst-with-to "Read f6" 'left "Read f6 inst")
(inst-with-to "Read f7" 'left "Read f7 inst")
(cut "allnc f^0(CoWrite f^0 -> (Sub irr)f^0 0 Zero 0 Zero ->
      exr f^(
       (Read (cterm (f^0) CoWrite f^0 ord
              exr f^1,f^2(CoWrite f^1 andd CoWrite f^2 andl
                          f^0 eqd(Cmp irr)f^1 f^2)))
       f^ andl (Cmp irr)f^6 f^0 eqd f^))")
 (assume "Hyp2")
 (inst-with-to "Hyp2" (pt "f^5") "CoWrite f5" "Hyp2 inst")
 (intro 1)
 (simp "<-" "Heq2")
 (use "Hyp2 inst")
 (use "AxUcfBound")
;Main Ind
(elim "Read f6 inst")
;base case
(assume "f^" "sd" "f[I] sub I_sd" "CoWrite outd sd f"
	"f^0" "CoWrite f0" "f0 in I")
(intro 0 (pt "(Cmp irr)f^ f^0"))
(split)
(intro 0 (pt "sd"))
(use "AxCompBound")
(use "f[I] sub I_sd")
(intro 1)
(intro 0 (pt "(Out irr)sd f^"))
(intro 0 (pt "f^0"))
(split)
(use "CoWrite outd sd f")
(split)
(use "CoWrite f0")
(simp "AxAssocOutComp")
(use "InitEqD")
(use "f[I] sub I_sd")
(use "InitEqD")
;step case
(assume "f^" "Read L" "IH L" "Read M" "IH M" "Read R" "IH R")
(assume "f^8" "CoWrite f8" "f8 in I")
(inst-with-to "CoWriteClause" (pt "f^8") "CoWrite f8" "Case f8")
(elim "Case f8")
;; Left. f8 eqd Id
(assume "f8 eqd Id")
(simp "f8 eqd Id")
(simp "AxCompIdR")
(intro 0 (pt "f^"))
(split)
(intro 1)
(inst-with-to "IH L" (pt "f^8") "CoWrite f8" "f8 in I" "IH L inst")
(by-assume-with "IH L inst" "f^9" "HypL and")
(inst-with-to "HypL and" 'left "HypL")
(simp-with "<-" "AxCompIdR" (pt "(In irr)L f^"))
(simp "<-" "f8 eqd Id")
(elim "HypL and")
(assume "HypLandL" "Heq3")
(simp "Heq3")
(use "HypL")
(inst-with-to "IH M" (pt "f^8") "CoWrite f8" "f8 in I" "IH M inst")
(by-assume-with "IH M inst" "f^9" "HypM and")
(inst-with-to "HypM and" 'right "HeqM")
(simp-with "<-" "AxCompIdR" (pt "(In irr)M f^"))
(simp "<-" "f8 eqd Id")
(simp "HeqM")
(use "HypM and")
(inst-with-to "IH R" (pt "f^8") "CoWrite f8" "f8 in I" "IH R inst")
(by-assume-with "IH R inst" "f^9" "HypR and")
(simp-with "<-" "AxCompIdR" (pt "(In irr)R f^"))
(simp "<-" "f8 eqd Id")
(inst-with-to "HypR and" 'right "HeqR")
(simp "HeqR")
(use "HypR and")
(use "InitEqD")
;; Right. Read f8
(assume "Hex Read f8")
(by-assume-with "Hex Read f8" "f^9" "Hand Read f9")
(inst-with-to "Hand Read f9" 'left "Read f9")
(assert "CoWrite f^8")
 (use "CoWrite f8")
(elim "Hand Read f9")
(assume "HandReadf9L" "HandReadf9R")
(simp "HandReadf9R")
;;sub ind
(elim "Read f9")
;;sub base
(assume "f^10" "sd" "f10[I] sub I_sd" "CoWrite out f10" "CoWrite f10")
(assert "(Sub irr)((Out irr)sd f^10)0 Zero 0 Zero")
 (use "AxOutIntro")
 (use "f10[I] sub I_sd")
 (use "f10[I] sub I_sd")
(assume "Out f10 in I")
(simp-with "AxInOutIdent" (pt "f^") (pt "f^10") (pt "sd")
	   "f10[I] sub I_sd")
(cases (pt "sd"))
;
(assume "Case L")
(assert "CoWrite((Out irr)L f^10)")
 (simp "<-" "Case L")
 (use "CoWrite out f10")
(assume "CoWrite outL f10")
(simphyp-with-to "Out f10 in I" "Case L" "Out L f10 in I")
(inst-with-to "IH L" (pt "(Out irr)L f^10") "CoWrite outL f10"
	      "Out L f10 in I" "Hex IH L")
(use "Hex IH L")
;
(assume "Case M")
(assert "CoWrite((Out irr)M f^10)")
 (simp "<-" "Case M")
 (use "CoWrite out f10")
(assume "CoWrite outM f10")
(simphyp-with-to "Out f10 in I" "Case M" "Out M f10 in I")
(inst-with-to "IH M" (pt "(Out irr)M f^10") "CoWrite outM f10"
	      "Out M f10 in I" "Hex IH M")
(use "Hex IH M")
;
(assume "Case R")
(assert "CoWrite((Out irr)R f^10)")
 (simp "<-" "Case R")
 (use "CoWrite out f10")
(assume "CoWrite outR f10")
(simphyp-with-to "Out f10 in I" "Case R" "Out R f10 in I")
(inst-with-to "IH R" (pt "(Out irr)R f^10") "CoWrite outR f10"
	      "Out R f10 in I" "Hex IH R")
(use "Hex IH R")
;;sub step
(assume "f^10" "Sub Read L" "Sub IH L" "Sub Read M" "Sub IH M"
	"Sub Read R" "Sub IH R" "CoWrite f10")
(inst-with-to "Lemma10" (pt "f^10") (pt "L") "CoWrite f10"
	      "CoWrite f10 inL")
(inst-with-to "Lemma10" (pt "f^10") (pt "M") "CoWrite f10"
	      "CoWrite f10 inM")
(inst-with-to "Lemma10" (pt "f^10") (pt "R") "CoWrite f10"
	      "CoWrite f10 inR")
(assert "(Sub irr)((In irr)L f^10)0 Zero 0 Zero")
 (use "AxUcfInputIn")
 (use "AxUcfBound")
(assume "f10 In L in I")
(inst-with-to "Sub IH L" "CoWrite f10 inL" "Hex Sub IH L")
(assert "(Sub irr)((In irr)M f^10)0 Zero 0 Zero")
 (use "AxUcfInputIn")
 (use "AxUcfBound")
(assume "f10 In M in I")
(inst-with-to "Sub IH M" "CoWrite f10 inM" "Hex Sub IH M")
(assert "(Sub irr)((In irr)R f^10)0 Zero 0 Zero")
 (use "AxUcfInputIn")
 (use "AxUcfBound")
(assume "f10 In R in I")
(inst-with-to "Sub IH R" "CoWrite f10 inR" "Hex Sub IH R")
(intro 0 (pt "(Cmp irr)f^ f^10"))
(split)
(intro 1)
(by-assume-with "Hex Sub IH L" "f^11" "Hand Sub IH L")
(simp "AxAssocCompIn")
(elim "Hand Sub IH L")
(assume "Hand Sub IH L L" "HeqL")
(simp "HeqL")
(use "Hand Sub IH L L")
;
(by-assume-with "Hex Sub IH M" "f^11" "Hand Sub IH M")
(simp "AxAssocCompIn")
(elim "Hand Sub IH M")
(assume "HandSubIHML" "HandSubIHMR")
(simp "HandSubIHMR")
(use "HandSubIHML")
;
(by-assume-with "Hex Sub IH R" "f^11" "Hand Sub IH R")
(simp "AxAssocCompIn")
(elim "Hand Sub IH R")
(assume "HandSubIHRL" "HandSubIHRR")
(simp "HandSubIHRR")
(use "HandSubIHRL")
;
(use "InitEqD")
(save "PropCompose")

(define eterm-cmp
  (proof-to-extracted-term (theorem-name-to-proof "PropCompose")))

(add-var-name "w" (py "algwrite"))
(add-var-name "rw" (py "algread algwrite"))
(add-var-name "rq" (py "algread(algwrite ysum algwrite yprod algwrite)"))
(add-var-name
 "fwrq" (py "algwrite=>algread(algwrite ysum algwrite yprod algwrite)"))
(add-var-name "ww" (py "algwrite yprod algwrite"))

(define neterm-cmp (nt eterm-cmp))

(pp neterm-cmp)
;; [w0,w1]
;;  (CoRec algwrite yprod algwrite=>algwrite)(w0 pair w1)
;;  ([ww2]
;;    [if (des[if ww2 ([w3,w4]w3)])
;;      [if (des[if ww2 ([w3,w4]w4)])
;;       (DummyL algread(algwrite ysum algwrite yprod algwrite))
;;       ([rw3]
;;        Inr((Rec algread algwrite=>algread(algwrite ysum algwrite yprod algwrite))
;;            rw3
;;            ([sd4,w5]
;;              (Put algwrite ysum algwrite yprod algwrite)sd4
;;              ((InL algwrite (algwrite yprod algwrite))w5))
;;            ([rw4,rq5,rw6,rq7,rw8]
;;              (Get algwrite ysum algwrite yprod algwrite)rq5 rq7)))]
;;      ([rw3]
;;       [if (des[if ww2 ([w4,w5]w5)])
;;         (Inr((Rec algread algwrite=>algread(algwrite ysum algwrite yprod algwrite))
;;             rw3
;;             ([sd4,w5]
;;               (Put algwrite ysum algwrite yprod algwrite)sd4
;;               ((InL algwrite (algwrite yprod algwrite))w5))
;;             ([rw4,rq5,rw6,rq7,rw8]
;;               (Get algwrite ysum algwrite yprod algwrite)rq5 rq7)))
;;         ([rw4]
;;          Inr((Rec algread algwrite=>algwrite=>algread(algwrite ysum algwrite yprod algwrite))
;;              rw3
;;              ([sd5,w6,w7]
;;                (Put algwrite ysum algwrite yprod algwrite)sd5
;;                ((InR (algwrite yprod algwrite) algwrite)(w6 pair w7)))
;;              ([rw5,fwrq6,rw7,fwrq8,rw9,fwrq10,w11]
;;                [if (des w11)
;;                  ((Get algwrite ysum algwrite yprod algwrite)(fwrq6 w11)
;;                  (fwrq8 w11)
;;                  (fwrq10 w11))
;;                  ([rw12]
;;                   (Rec algread algwrite=>algwrite=>algread(algwrite ysum algwrite yprod algwrite))
;;                   rw12
;;                   ([sd13,w14,w15]
;;                     [if sd13 (fwrq6 w14) (fwrq8 w14) (fwrq10 w14)])
;;                   ([rw13,fwrq14,rw15,fwrq16,rw17,fwrq18,w19]
;;                     (Get algwrite ysum algwrite yprod algwrite)
;;                     (fwrq14(cLemmaOneZero L w19))
;;                     (fwrq16(cLemmaOneZero M w19))
;;                     (fwrq18(cLemmaOneZero R w19)))
;;                   w11)])
;;              [if ww2 ([w5,w6]w6)]))])])

;; 5. Definite integration of a type-0 ucf.
;; 1/2 * (Integral f), which in in [-1,1]
(add-program-constant "HInt" (py "irr=>r"))
(add-program-constant "H" (py "r=>r"))
(add-program-constant "P" (py "r=>r=>r"))

(add-global-assumption
 "AxHIntIdIrr"
 "(HInt irr r)(IdIrr irr) eqd (Z r)")

(add-global-assumption
 "AxHIntInI"
 "all f^((Elem r)((HInt irr r)f^)(0#1)Zero)")

(add-global-assumption
 "AxHIntOut"
 "all f^,sd((HInt irr r)f^ eqd
              (H r)((P r)((Av r)((HInt irr r)((Out irr)sd f^)) sd)
                         ((Av r)((HInt irr r)((Out irr)sd f^)) sd)))")

(add-global-assumption
 "AxHIntOutMod"
 "all f^,sd((HInt irr r)f^ eqd
             ((Av r)((HInt irr r)((Out irr)sd f^)) sd))")

(add-global-assumption
 "AxHIntIn"
 "all f^((HInt irr r)f^ eqd
              (H r)((P r)((HInt irr r)((In irr)L f^))
                         ((HInt irr r)((In irr)R f^))))")

;;; axioms on abstract real numbers (used also in realsds.scm).
(add-global-assumption
 "AxZ"
 "all n (Elem r)(Z r)(0#1)n")

(add-global-assumption
 "AxElemAv"
 "all x^,a,sd,n((Elem r)x^ a n ->
            (Elem r)((Av r)x^ sd)((a+SDToInt sd)/2)(Succ n))")

(add-global-assumption
 "AxAvrg"
 "all x^1,x^2,a1,a2,n((Elem r)x^1 a1 n -> (Elem r)x^2 a2 n ->
                      (Elem r)((H r)((P r)x^1 x^2))((a1+a2)/2) n)")

;; PropInt
;; CoWrite f -> all n ex p (Int f) in I p n
(set-goal "allnc f^(CoWrite f^ ->
                all n exl p((Elem r)((HInt irr r)f^)p n))")
(cut "all n allnc f^(CoWrite f^ ->
                exl p((Elem r)((HInt irr r)f^)p n))")
 (assume "H0" "f^" "CoWrite f" "n")
 (use "H0")
 (use "CoWrite f")
(ind)
;;base case
(assume "f^" "CoWrite f^")
(intro 0 (pt "0#1"))
(use "AxHIntInI")
;;step case
(assume "n" "IH")
(assume "f^" "CoWrite f")
(inst-with-to "CoWriteClause" (pt "f^") "CoWrite f" "Hcase")
(elim "Hcase")
;;left case
(assume "f eqd IdIrr")
(simp "f eqd IdIrr")
(intro 0 (pt "0#1"))
(simp "AxHIntIdIrr")
(use "AxZ")
;;right case
(assume "HRead")
(by-assume "HRead" "f^0" "Hand")
(inst-with-to "Hand" 'left "Read f0")
(inst-with-to "Hand" 'right "f eqd f0")
(simp "f eqd f0")
(elim "Read f0")
;;side base case
(assume "f^1" "sd" "f1[I] sub I_sd" "CoWrite Out f1")
(inst-with-to "IH" (pt "(Out irr)sd f^1") "CoWrite Out f1" "IH inst")
(elim "IH inst")
(assume "a" "H1")
(intro 0 (pt "(a+(SDToInt sd))/2"))
(simp "AxHIntOutMod" (pt "sd"))
(use "AxElemAv")
(use "H1")
;;side step case
(assume "f^1" "ReadL" "IHL" "ReadM" "IHM" "ReadR" "IHR")
(by-assume "IHL" "p1" "HElem p1")
(by-assume "IHR" "p2" "HElem p2")
(intro 0 (pt "(p1+p2)/2"))
(simp "AxHIntIn")
(use "AxAvrg")
(use "HElem p1")
(use "HElem p2")
(save "PropInt")

(define eterm-int
  (proof-to-extracted-term (theorem-name-to-proof "PropInt")))
(define neterm-int (nt eterm-int))

(pp (rename-variables neterm-int))
;; [w,n]
;;  (Rec nat=>algwrite=>rat)n([w0]0)
;;  ([n0,(algwrite=>rat),w0]
;;    [if (des w0)
;;      0
;;      ([rw]
;;       (Rec algread algwrite=>rat)rw
;;       ([sd0,w1]((algwrite=>rat)w1+SDToInt sd0)/2)
;;       ([rw0,a,rw1,a0,rw2,a1](a+a1)/2))])
;;  w

;; 6. Experiments
;
;; For Haskell extraction: animate after defining neterm-a, so that
;; the extracted function call the extracted functions from the lemmas
;; instead of inlining them (might be good to animate the "boring"
;; StandardSplit, SplitAtRational, NegOrPos)

(animate "Lemma10")
(animate "Lemma9")
(animate "Lemma8")
(animate "LemmaNatProp")
(animate "LemmaApply")
(animate "Lemma6")
(animate "Lemma5")
(animate "AuxLemma4")
(animate "Lemma4")
(animate "Lemma3")
(animate "Lemma2")
(animate "Lemma1")
(animate "NegOrPos")
(animate "SplitAtRational")
(animate "StandardSplit")

;; a rational number to its square root.
(add-program-constant "sqrt" (py "rat=>nat=>rat"))
(add-computation-rule "sqrt a Zero" "Succ Zero")
(add-computation-rule "sqrt a (Succ n)"
		      "((sqrt a n) + (a / (sqrt a n)))/2")

;; f1(x) = -x
(define f1 (pt "[n]((PairConstr nat algB)(n+1)(CInitB([a](0-a))))"))

;; f2(x) = sqrt(x+2) - 1
;; in this case, the Cauchy modulus is M(n)=n+1.
(define f2
  (pt "[n]((PairConstr nat algB)(n--1)(CInitB([a](sqrt(a+2)(n+1)-1))))"))

;; f3(x) = 2x^2 - 1
(define f3 (pt "[n]((PairConstr nat algB)(n+1)(CInitB([a](2*a*a-1))))"))

'(
(terms-to-haskell-program
 "~/readwrite.hs"
 (list (list neterm-a "type1to0")
       (list neterm-b "type0to1")
       (list neterm-apply "application")
       (list neterm-cmp "composition")
       (list neterm-int "integration")
       (list f1 "f1")
       (list f2 "f2")
       (list f3 "f3")))
)

'(
{- takeIv -}
takeIv _ II = []
takeIv 0 (C d x) = []
takeIv n (C d x) = (show d) : (takeIv (n-1) x)

{- pretty-printing read-write machines -}

spc l = concat $ replicate l " "

ppW _ l Stop = "Stop"
ppW 0 l (Cont x) = "Stop"
ppW n l (Cont x) = "Cont " ++ (ppR n (l+5) x)
ppR n l (Put d x) = "Put " ++ (show d) ++ " " ++ (ppW (n-1) (l+6) x)
ppR n l (Get x y z) = concat ["Get ", ppR n (l+4) x, "\n", spc (l+4),
			      ppR n (l+4) y, "\n", spc (l+4),
			      ppR n (l+4) z]
pp n w = putStrLn (ppW n 0 w)
)

;; 6.1 type-1 to type-0

;; Main> pp 3 (type1to0 f1)

;; 6.2 Application

;; Main> takeIv 10 (application (type1to0 f1) (C L(C L(C L(C L II)))))
;
;; ["R","R","R","R","M","M","M","M","M","M"] {- result -}

;; 6.3 Composition
;
;; Main> takeIv 10 $ application (composition (type1to0 f1) (type1to0 f3)) (C M(C M(C M(C M II))))
;
;; ["R","R","R","R","R","R","R","R","R","R"] {- result -}

;; 6.4 Definite integration
;
;; Main> integration (type1to0 f2) 8
;
;; 1633 % 4096 {- result -}
;
;; Main> integration (composition (type1to0 f3) (type1to0 f1)) 5
;
;; (-169) % 512 {- result -}
;
;; Main> integration (type1to0 f3) 5
;
;; (-679) % 2048 {- result -}

;; 6.5 Some experiments in Minlog

(pp (nt (undelay-delayed-corec (mk-term-in-app-form neterm-a f1) 1)))
;; profile:
;;     18350 collections
;;     185872 ms elapsed cpu time, including 16000 ms collecting
;;     186175 ms elapsed real time, including 16016 ms collecting
;;     19589000744 bytes allocated, including 19586602704 bytes reclaimed
;
;; Cont
;; ((Get algwrite)
;;  ((Get algwrite)
;;   ((Get algwrite)
;;    ((Put algwrite)R
;;     ((CoRec (nat=>nat yprod algB)=>algwrite) ...

(define minusone
  (pt "C L(C L(C L(C L(C L(C L(C L(C L II)))))))"))

(define app-flip-minusone
  (undelay-delayed-corec
   (mk-term-in-app-form
    neterm-apply (make-term-in-app-form neterm-a f1) minusone)
   2))

(pp (nt app-flip-minusone))
;; profile:
;;     866 collections
;;     8344 ms elapsed cpu time, including 728 ms collecting
;;     8365 ms elapsed real time, including 723 ms collecting
;;     923949632 bytes allocated, including 924431696 bytes reclaimed
;
;; C R
;; (C R
;;  ((CoRec algwrite@@iv=>iv)
;;   ((CoRec (nat=>nat yprod algB)=>algwrite) ...


(pp (nt (mk-term-in-app-form
	 neterm-int
	 (pt "Cont((Get algwrite)
                      ((Put algwrite) R Stop)
                      ((Put algwrite) R Stop)
                      ((Put algwrite) R Stop))")
	 (pt "Succ Zero"))))
;; 1#2

(pp (nt
     (undelay-delayed-corec
      (mk-term-in-app-form
       neterm-int
       (undelay-delayed-corec (make-term-in-app-form neterm-a f2) 2)
       (pt "PosToNat 2"))
      1)))
;; profile:
;;     377 collections
;;     3372 ms elapsed cpu time, including 316 ms collecting
;;     3381 ms elapsed real time, including 327 ms collecting
;;     402977200 bytes allocated, including 402263504 bytes reclaimed
;; 3#8
