; $Id:  $

; (load "~/minlog/init.scm")

(set! COMMENT-FLAG #f)
(libload "nat.scm")
(libload "numbers.scm")
(load "~/minlog/examples/analysis/simpreal.scm")
(set! COMMENT-FLAG #t)

(remove-var-name "i" "j") ;will be used as variable name for sdtwo.
(remove-var-name "M") ;will be used as constructor for sd
(remove-token "M")
(remove-var-name "x" "y" "z") ;will be used for abstract reals
(remove-var-name "d") ;will be used for signed digits

(add-tvar-name "r") ;abstract real
(add-var-name "x" "y" "z" (py "r"))

; We assume an embedding of int into r.

(add-program-constant "IntToR" (py "int=>r"))

(add-program-constant "H" (py "r=>r")) ;half
(add-program-constant "P" (py "r=>r=>r")) ;plus

; We assume some properties of the abstract reals, as rewrite rules:
; (x+k)/2+l -> (x+(k+2l))/2
; (x+k)/4+l -> (x+(k+4l))/4
; (x+k)/2+(y+l)/2 -> ((x+y)+(k+l))/2
; x+0 -> x
; 0+y -> y
; 0/2 -> 0
; (2*k)/2 -> k
; k+l (+ in r) -> k+l (+ in int)

(add-rewrite-rules
 "(P r)((H r)((P r)x^((IntToR r)k)))((IntToR r)l)"
 "(H r)((P r)x^((IntToR r)(k+2*l)))"

 "(P r)((H r)((H r)((P r)x^((IntToR r)k))))((IntToR r)l)"
 "(H r)((H r)((P r)x^((IntToR r)(k+4*l))))"

 "(P r)((H r)((P r)x^((IntToR r)k)))((H r)((P r)y^((IntToR r)l)))"
 "(H r)((P r)((P r)x^ y^)((IntToR r)(k+l)))"

 "(P r)x^((IntToR r)0)"
 "x^"

 "(P r)((IntToR r)0)y^"
 "y^"

 "(H r)((IntToR r)0)"
 "(IntToR r)0"

 "(H r)((IntToR r)(2*k))"
 "(IntToR r)k"

 "(P r)((IntToR r)k)((IntToR r)l)"
 "(IntToR r)(k+l)")

; Lemma1: x=0 -> y=0 -> x+y=(x+y+0)/2

; "Lemma1"
(set-goal "all x^,y^(
  x^ eqd(IntToR r)0 ->
  y^ eqd(IntToR r)0 ->
  (P r)x^ y^ eqd(H r)((P r)((P r)x^ y^)((IntToR r)0)))")
(assume "x^" "y^" "x=0" "y=0")
(simp "x=0")
(simp "y=0")
; ?_4:(P r)((IntToR r)0)((IntToR r)0)eqd
;     (H r)((P r)((P r)((IntToR r)0)((IntToR r)0))((IntToR r)0))
(ng #t)
(use "InitEqD")
; Proof finished.
(save "Lemma1")

; Lemma2: x=0 -> y=(y1+l1)/2 -> x+y=(x+y+l1)/2

; "Lemma2"
(set-goal "all x^,y^,y^1,l1(
  x^ eqd(IntToR r)0 ->
  y^ eqd(H r)((P r)y^1((IntToR r)l1)) ->
  (P r)x^ y^ eqd
  (H r)((P r)((P r)x^ y^1)((IntToR r)l1)))")
(assume "x^" "y^" "y^1" "l1" "x=0" "y=(y1+l1)/2")
(simp "x=0")
(simp "y=(y1+l1)/2")
; ?_4:(P r)((IntToR r)0)((H r)((P r)y^1((IntToR r)l1)))eqd
;     (H r)((P r)((P r)((IntToR r)0)y^1)((IntToR r)l1))
(ng #t)
(use "InitEqD")
; Proof finished.
(save "Lemma2")

; Lemma3: x=(x1+k1)/2 -> y=0 -> x+y=(x1+y+k1)/2

; "Lemma3"
(set-goal "all x^,x^1,k1,y^(
  x^ eqd(H r)((P r)x^1((IntToR r)k1)) ->
  y^ eqd(IntToR r)0 ->
  (P r)x^ y^ eqd
  (H r)((P r)((P r)x^1 y^)((IntToR r)k1)))")
(assume "x^" "x^1" "k1" "y^" "x=(x1+k1)/2" "y=0")
(simp "x=(x1+k1)/2")
(simp "y=0")
; ?_4:(P r)((H r)((P r)x^1((IntToR r)k1)))((IntToR r)0)eqd
;     (H r)((P r)((P r)x^1((IntToR r)0))((IntToR r)k1))
(ng #t)
(use "InitEqD")
; Proof finished.
(save "Lemma3")

; Lemma4: x=(x1+k1)/2 -> y=(y1+l1)/2 -> x+y=(x1+y1+k1+l1)/2

; "Lemma4"
(set-goal "all x^,x^1,k1,y^,y^1,l1(
  x^ eqd(H r)((P r)x^1((IntToR r)k1)) ->
  y^ eqd(H r)((P r)y^1((IntToR r)l1)) ->
  (P r)x^ y^ eqd
  (H r)((P r)((P r)x^1 y^1)((IntToR r)(k1+l1))))")
(assume "x^" "x^1" "k1" "y^" "y^1" "l1" "x=(x1+k1)/2" "y=(y1+l1)/2")
(simp "x=(x1+k1)/2")
(simp "y=(y1+l1)/2")
(ng #t)
(use "InitEqD")
; Proof finished.
(save "Lemma4")

; Lemma5: x=0 -> y=0 -> x+y+k=(x+y+2k)/2

; "Lemma5"
(set-goal "all x^,y^,k(
  x^ eqd(IntToR r)0 ->
  y^ eqd(IntToR r)0 ->
  (P r)((P r)x^ y^)((IntToR r)k) eqd
  (H r)((P r)((P r)x^ y^)((IntToR r)(2*k))))")
(assume "x^" "y^" "k" "x=0" "y=0")
(simp "x=0")
(simp "y=0")
; ?_4:(P r)((P r)((IntToR r)0)((IntToR r)0))((IntToR r)k)eqd
;     (H r)((P r)((P r)((IntToR r)0)((IntToR r)0))((IntToR r)(2*k)))
(ng #t)
(use "InitEqD")
; Proof finished.
(save "Lemma5")

; Lemma6: x=0 -> y=(y1+l1)/2 -> x+y+k=(x+y1+l1+2k)/2

; "Lemma6"
(set-goal "all x^,y^,y^1,l1,k(
  x^ eqd(IntToR r)0 ->
  y^ eqd(H r)((P r)y^1((IntToR r)l1)) ->
  (P r)((P r)x^ y^)((IntToR r)k) eqd
  (H r)((P r)((P r)x^ y^1)((IntToR r)(l1+2*k))))")
(assume "x^" "y^" "y^1" "l1" "k" "x=0" "y=(y1+l1)/2")
(simp "x=0")
(simp "y=(y1+l1)/2")
(ng #t)
(use "InitEqD")
; Proof finished.
(save "Lemma6")

; Lemma7: x=(x1+k1)/2 -> y=0 -> x+y+k=(x1+y+k1+2k)/2

; "Lemma7"
(set-goal "all x^,x^1,k1,y^,k(
  x^ eqd(H r)((P r)x^1((IntToR r)k1)) ->
  y^ eqd(IntToR r)0 ->
  (P r)((P r)x^ y^)((IntToR r)k) eqd
  (H r)((P r)((P r)x^1 y^)((IntToR r)(k1+2*k))))")
(assume "x^" "x^1" "k1" "y^" "k" "x=(x1+k1)/2" "y=0")
(simp "x=(x1+k1)/2")
(simp "y=0")
; ?_4:(P r)((P r)((H r)((P r)x^1((IntToR r)k1)))((IntToR r)0))((IntToR r)k)eqd
;     (H r)((P r)((P r)x^1((IntToR r)0))((IntToR r)(k1+2*k)))
(ng #t)
(use "InitEqD")
; Proof finished.
(save "Lemma7")

; Lemma8: x=(x1+k1)/2 -> y=(y1+l1)/2 -> x+y+k=(x+y+k1+l1+2k)/2

; "Lemma8"
(set-goal "all x^,x^1,k1,y^,y^1,l1,k(
  x^ eqd(H r)((P r)x^1((IntToR r)k1)) ->
  y^ eqd(H r)((P r)y^1((IntToR r)l1)) ->
  (P r)((P r)x^ y^)((IntToR r)k) eqd
  (H r)((P r)((P r)x^1 y^1)((IntToR r)(k1+l1+2*k))))")
(assume "x^" "x^1" "k1" "y^" "y^1" "l1" "k" "x=(x1+k1)/2" "y=(y1+l1)/2")
(simp "x=(x1+k1)/2")
(simp "y=(y1+l1)/2")
(ng #t)
(use "InitEqD")
; Proof finished.
(save "Lemma8")

; Lemma9: x+y+k=(x0+y0+k0+4l)/2 -> (x+y+k)/4=((x0+y0+k0)/4+l)/2

; "Lemma9"
(set-goal "all x^,y^,k,x^0,y^0,k0,l(
  (P r)((P r)x^ y^)((IntToR r)k) eqd
  (H r)((P r)((P r)x^0 y^0)((IntToR r)(k0+4*l))) ->
  (H r)((H r)((P r)((P r)x^ y^)((IntToR r)k)))eqd
  (H r)((P r)((H r)((H r)((P r)((P r)x^0 y^0)((IntToR r)k0))))((IntToR r)l)))")
(assume "x^" "y^" "k" "x^0" "y^0" "k0" "l" "x+y+k=(x0+y0+k0+4l)/2")
(simp "x+y+k=(x0+y0+k0+4l)/2")
(ng #t)
(use "InitEqD")
; Proof finished.
(save "Lemma9")

; Next we define the algebra of signed digits, similar to boole.

(add-alg "sd" '("L" "sd") '("M" "sd") '("R" "sd"))
(add-totality "sd")

(add-alg "sdtwo"
	 '("LL" "sdtwo")
	 '("LT" "sdtwo")
	 '("MT" "sdtwo")
	 '("RT" "sdtwo")
	 '("RR" "sdtwo"))
(add-totality "sdtwo")

(add-var-name "d" "e" (py "sd"))
(add-var-name "i" "j" (py "sdtwo"))

; We need a conversion of sd into int

(add-program-constant "SDToInt" (py "sd=>int"))

(add-computation-rules
 "SDToInt L" "IntN 1"
 "SDToInt M" "0"
 "SDToInt R" "1")


; "SDToIntTotal"
(set-goal (term-to-totality-formula (pt "SDToInt")))
(assume "d^" "Td")
(elim "Td")
(ng #t)
(use "TotalIntIntNeg")
(use "TotalPosOne")
(ng #t)
(use "TotalIntIntZero")
(ng #t)
(use "TotalIntIntPos")
(use "TotalPosOne")
; Proof finished.
(save "SDToIntTotal")

(add-program-constant "SDTwoToInt" (py "sdtwo=>int"))

(add-computation-rules
 "SDTwoToInt LL" "IntN 2"
 "SDTwoToInt LT" "IntN 1"
 "SDTwoToInt MT" "0"
 "SDTwoToInt RT" "1"
 "SDTwoToInt RR" "2")

; "SDTwoToIntTotal"
(set-goal (term-to-totality-formula (pt "SDTwoToInt")))
(assume "i^" "Ti")
(elim "Ti")
(ng #t)
(use "TotalIntIntNeg")
(use "TotalPosSZero")
(use "TotalPosOne")
(ng #t)
(use "TotalIntIntNeg")
(use "TotalPosOne")
(ng #t)
(use "TotalIntIntZero")
(ng #t)
(use "TotalIntIntPos")
(use "TotalPosOne")
(ng #t)
(use "TotalIntIntPos")
(use "TotalPosSZero")
(use "TotalPosOne")
; Proof finished.
(save "SDTwoToIntTotal")


(add-alg "iv" '("II" "iv") '("C" "sd=>iv=>iv"))
(add-var-name "v" "w" (py "iv"))

(add-totality "iv")

(pp (rename-variables (proof-to-formula (theorem-name-to-proof "TotalIvC"))))
; allnc d^,v^(TotalSd d^ -> TotalIv v^ -> TotalIv(C d^ v^))


; We inductively define a set I of reals, by the clauses
; InitI: I 0
; GenI: I x -> I(x+d)/2 (d a signed digit).

(add-ids
 (list (list "I" (make-arity (py "r")) "iv"))
 '("I((IntToR r)0)" "InitI")
 '("allnc x^ all d(I x^ -> I((H r)((P r)x^((IntToR r)(SDToInt d)))))"
   "GenI"))

(add-co "I")

(pp (rename-variables (aconst-to-formula
		       (theorem-name-to-aconst "CoIClause"))))

'(
allnc x^(
 CoI x^ -> 
 x^ eqd(IntToR r)0 orr 
 exr x^0 ex d(x^ eqd(H r)((P r)x^0((IntToR r)(SDToInt d))) & CoI x^0))
)

(display-alg "iv")
; iv
; 	II:	iv
; 	C:	sd=>iv=>iv

; Generally we have I x^ -> CoI x^.

; "IToCoIClause"
(set-goal "allnc x^(I x^ ->
 x^ eqd(IntToR r)0 orr 
 exr x^0 ex d(x^ eqd(H r)((P r)x^0((IntToR r)(SDToInt d))) & I x^0))")
(assume "x^" "Ix")
(elim "Ix")
(intro 0)
(use "InitEqD")
(assume "x^1" "d1" "Ix1" "Useless")
(drop "Useless")
(intro 1)
(intro 0 (pt "x^1"))
(ex-intro (pt "d1"))
(split)
(use "InitEqD")
(use "Ix1")
; Proof finished.
(save "IToCoIClause")

(define eterm
  (proof-to-extracted-term (theorem-name-to-proof "IToCoIClause")))
(define neterm (nt eterm))
(pp neterm)

; [v0][if v0 (DummyL sd@@iv) ([d1,v2]Inr(d1@v2))]

; "IToCoI"
(set-goal "allnc x^(I x^ -> CoI x^)")
(assume "x^" "Ix")
(coind "Ix")
(assume "x^1" "Ix1")
(inst-with-to "IToCoIClause" (pt "x^1") "Ix1" "Disj")
(elim "Disj")
(drop "Disj")
(assume "x1=0")
(intro 0)
(use "x1=0")
(drop "Disj")
(assume "ExHyp")
(intro 1)
(by-assume "ExHyp" "x^2" "x2Prop")
(by-assume "x2Prop" "d" "x2dProp")
(intro 0 (pt "x^2"))
(ex-intro (pt "d"))
(split)
(intro 1)
(use "x2dProp")
(use "x2dProp")
; Proof finished.
(save "IToCoI")

; (cdp (theorem-name-to-proof "IToCoI"))

(define eterm (proof-to-extracted-term (theorem-name-to-proof "IToCoI")))

(animate "IToCoIClause")
(define neterm (nt eterm))
(pp neterm)

'(
[v0]
 (CoRec iv=>iv)v0
 ([v1][if v1 (DummyL sd@@(iv ysum iv)) ([d2,v3]Inr(d2@(InR iv iv)v3))])
)

; We define JOne:sd=>sd=>sdtwo with 

(add-program-constant "JOne" (py "sd=>sd=>sdtwo"))

(add-computation-rules
 "JOne L L" "LL"
 "JOne L M" "LT"
 "JOne L R" "MT"
 "JOne M L" "LT"
 "JOne M M" "MT"
 "JOne M R" "RT"
 "JOne R L" "MT"
 "JOne R M" "RT"
 "JOne R R" "RR")

; "JOneTotal"
(set-goal (term-to-totality-formula (pt "JOne")))
(assume "d^1" "Td1" "d^2" "Td2")
(elim "Td1")

(elim "Td2")
(ng #t)
(use "TotalSdtwoLL")
(ng #t)
(use "TotalSdtwoLT")
(ng #t)
(use "TotalSdtwoMT")

(elim "Td2")
(ng #t)
(use "TotalSdtwoLT")
(ng #t)
(use "TotalSdtwoMT")
(ng #t)
(use "TotalSdtwoRT")

(elim "Td2")
(ng #t)
(use "TotalSdtwoMT")
(ng #t)
(use "TotalSdtwoRT")
(ng #t)
(use "TotalSdtwoRR")
; Proof finished.
(save "JOneTotal")

; "JOneProp"
(set-goal "all d,e(SDToInt d+SDToInt e=SDTwoToInt(JOne d e))")
(cases)
(cases)
(use "Truth-Axiom")
(use "Truth-Axiom")
(use "Truth-Axiom")
(cases)
(use "Truth-Axiom")
(use "Truth-Axiom")
(use "Truth-Axiom")
(cases)
(use "Truth-Axiom")
(use "Truth-Axiom")
(use "Truth-Axiom")
; Proof finished.
(save "JOneProp")

; "XSubY"
(set-goal "allnc x^,y^(
      CoI x^ -> 
      CoI y^ -> 
      exr x^0,y^0 ex i(
       (P r)x^ y^ eqd
       (H r)((P r)((P r)x^0 y^0)((IntToR r)(SDTwoToInt i))) &
       CoI x^0 & CoI y^0))")
(assume "x^" "y^" "CoIx" "CoIy")
; We first distinguish cases on CoI x^
(inst-with-to "CoIClause" (pt "x^") "CoIx" "xCases")
(elim "xCases")
(drop "xCases")
(assume "x=0")
; We distinguish cases on CoI y^
(inst-with-to "CoIClause" (pt "y^") "CoIy" "yCases")
(elim "yCases")
(drop "yCases")
(assume "y=0")

; Case N,N (i.e., x=0 and y=0)
(intro 0 (pt "x^"))
(intro 0 (pt "y^"))
(ex-intro (pt "MT"))
(split)
(ng #t)
; x+y=(x+y+0)/2 since x=0 and y=0
(use "Lemma1")
(use "x=0")
(use "y=0")
(split)
(use "CoIx")
(use "CoIy")

; Case N,A (i.e., x=0 and y=(y1+e1)/2)
(drop "yCases")
(assume "yCases1")
(by-assume "yCases1" "y^1" "y1Prop")
(by-assume "y1Prop" "e1" "y1e1Prop")
(intro 0 (pt "x^"))
(intro 0 (pt "y^1"))
(ex-intro (pt "JOne M e1"))
(split)
; ?_37: (P r)x^ y^ eqd(H r)((Pi r)((P r)x^ y^1)(SDTwoToInt(JOne M e1)))
; JOneProp: all d,e SDToInt d+SDToInt e=SDTwoToInt(JOne d e)
(simp "<-" "JOneProp")
(ng #t)
; x+y=(x+y1+e1)/2 since x=0 and y=(y1+e1)/2
(use "Lemma2")
(use "x=0")
(use "y1e1Prop")
(split)
(use "CoIx")
(use "y1e1Prop")

; Now the case x=(x1+d1)/2
(drop "xCases")
(assume "xCases1")
(by-assume "xCases1" "x^1" "x1Prop")
(by-assume "x1Prop" "d1" "x1d1Prop")
; We again distinguish cases on CoI y^
(inst-with-to "CoIClause" (pt "y^") "CoIy" "yCases")
(elim "yCases")
(drop "yCases")
(assume "y=0")

; Case A,N (i.e., x=(x1+d1)/2 and y=0)
(intro 0 (pt "x^1"))
(intro 0 (pt "y^"))
(ex-intro (pt "JOne d1 M"))
(split)
(simp "<-" "JOneProp")
(ng #t)
; x+y=(x1+y+d1)/2 since x=(x1+d1)/2 and y=0
(use "Lemma3")
(use "x1d1Prop")
(use "y=0")
(split)
(use "x1d1Prop")
(use "CoIy")

; Case A,A (i.e., x=(x1+d1)/2 and y=(y1+e1)/2)
(drop "yCases")
(assume "yCases1")
(by-assume "yCases1" "y^1" "y1Prop")
(by-assume "y1Prop" "e1" "y1e1Prop")
(intro 0 (pt "x^1"))
(intro 0 (pt "y^1"))
(ex-intro (pt "JOne d1 e1"))
(split)
(simp "<-" "JOneProp")
(ng #t)
; x+y=(x1+y1+d1+e1)/2 since x=(x1+d1)/2 and y=(y1+e1)/2
(use "Lemma4")
(use "x1d1Prop")
(use "y1e1Prop")
(split)
(use "x1d1Prop")
(use "y1e1Prop")
; Proof finished.
(save "XSubY")

(define eterm (proof-to-extracted-term (theorem-name-to-proof "XSubY")))
(add-var-name "dv" (py "sd@@iv"))
(define neterm (nt eterm))
(pp neterm)

'(
[v0,v1]
 [if (des v0)
   [if (des v1) (MT@v0@v1) ([dv2]JOne M left dv2@v0@right dv2)]
   ([dv2]
    [if (des v1)
      (JOne left dv2 M@right dv2@v1)
      ([dv3]JOne left dv2 left dv3@right dv2@right dv3)])]
)

(ppc neterm)

'(
[v0,v1]
 [case (des v0)
   ((DummyL sd@@iv) -> 
   [case (des v1)
     ((DummyL sd@@iv) -> MT@v0@v1)
     (Inr dv2 -> JOne M left dv2@v0@right dv2)])
   (Inr dv2 -> 
   [case (des v1)
     ((DummyL sd@@iv) -> JOne left dv2 M@right dv2@v1)
     (Inr dv3 -> JOne left dv2 left dv3@right dv2@right dv3)])]
)

; This term can be read as follows.  Given v0, v1, destruct both.
; Assume that both are composed, i.e., of the form dv2 and dv3.  Take
; their components d2,v2 and d3,v3.  Then the result is JOne d2 d3
; pair v2 pair v3.

; We define J: sd=>sd=>sdtwo=>sdtwo and D: sd=>sd=>sdtwo=>sd such that
; d+e+2*i=J d e i+4*(D d e i).  For J'(d+e+2*i) := J d e i and
; D'(d+e+2*i) := D d e i we want

; J' k = [if (rem k 4=3) 1 (sg k)*(rem k 4)]
; D' k = [if (abs k<=2) 0 (sg k)]

; Hence J' should map
; IntN 6 -> IntN 2
; IntN 5 -> IntN 1
; IntN 4 -> 0
; IntN 3 -> 1
; IntN 2 -> IntN 2
; IntN 1 -> IntN 1
; 0 -> 0
; 1 -> 1
; 2 -> 2
; 3 -> IntN 1
; 4 -> 0
; 5 -> 1
; 6 -> 2

; Similarly D' should map
; IntN 6 -> IntN 1
; IntN 5 -> IntN 1
; IntN 4 -> IntN 1
; IntN 3 -> IntN 1
; IntN 2 -> 0
; IntN 1 -> 0
; 0 -> 0
; 1 -> 0
; 2 -> 0
; 3 -> 1
; 4 -> 1
; 5 -> 1
; 6 -> 1

; k        J'k      D'k      J'k+4*D'k
; IntN 6   IntN 2   IntN 1   IntN 6
; IntN 5   IntN 1   IntN 1   IntN 5
; IntN 4   0        IntN 1   IntN 4
; IntN 3   1        IntN 1   IntN 3
; IntN 2   IntN 2   0        IntN 2
; IntN 1   IntN 1   0        IntN 1
; 0        0        0        0
; 1        1        0        1
; 2        2        0        2
; 3        IntN 1   1        3
; 4        0        1        4
; 5        1        1        5
; 6        2        1        6

; Then for abs k<=6 we have k=J' k+D' k:
; IntN 6=IntN 2+4*(IntN 1)
; IntN 5=IntN 1+4*(IntN 1)
; IntN 4=0+4*(IntN 1)
; IntN 3=1+4*(IntN 1)
; IntN 2=IntN 2
; IntN 1=IntN 1
; 0=0
; 1=1
; 2=2
; 3=IntN 1+4
; 4=0+4
; 5=1+4
; 6=2+4

(add-program-constant "J" (py "sd=>sd=>sdtwo=>sdtwo"))
(add-computation-rules
 "J L L LL" "LL"
 "J L L LT" "MT"
 "J L L MT" "LL"
 "J L L RT" "MT"
 "J L L RR" "RR"

 "J L M LL" "LT"
 "J L M LT" "RT"
 "J L M MT" "LT"
 "J L M RT" "RT"
 "J L M RR" "LT"

 "J L R LL" "MT"
 "J L R LT" "LL"
 "J L R MT" "MT"
 "J L R RT" "RR"
 "J L R RR" "MT"

 "J M L LL" "LT"
 "J M L LT" "RT"
 "J M L MT" "LT"
 "J M L RT" "RT"
 "J M L RR" "LT"

 "J M M LL" "MT"
 "J M M LT" "LL"
 "J M M MT" "MT"
 "J M M RT" "RR"
 "J M M RR" "MT"

 "J M R LL" "RT"
 "J M R LT" "LT"
 "J M R MT" "RT"
 "J M R RT" "LT"
 "J M R RR" "RT"

 "J R L LL" "MT"
 "J R L LT" "LL"
 "J R L MT" "MT"
 "J R L RT" "RR"
 "J R L RR" "MT"

 "J R M LL" "RT"
 "J R M LT" "LT"
 "J R M MT" "RT"
 "J R M RT" "LT"
 "J R M RR" "RT"

 "J R R LL" "LL"
 "J R R LT" "MT"
 "J R R MT" "RR"
 "J R R RT" "MT"
 "J R R RR" "RR")

; "JTotal"
(set-goal (term-to-totality-formula (pt "J")))
(assume "d^1" "Td1" "d^2" "Td2" "i^" "Ti")
(elim "Td1")

(elim "Td2")

(elim "Ti")
(ng #t)
(use "TotalSdtwoLL")
(ng #t)
(use "TotalSdtwoMT")
(ng #t)
(use "TotalSdtwoLL")
(ng #t)
(use "TotalSdtwoMT")
(ng #t)
(use "TotalSdtwoRR")

(elim "Ti")
(ng #t)
(use "TotalSdtwoLT")
(ng #t)
(use "TotalSdtwoRT")
(ng #t)
(use "TotalSdtwoLT")
(ng #t)
(use "TotalSdtwoRT")
(ng #t)
(use "TotalSdtwoLT")

(elim "Ti")
(ng #t)
(use "TotalSdtwoMT")
(ng #t)
(use "TotalSdtwoLL")
(ng #t)
(use "TotalSdtwoMT")
(ng #t)
(use "TotalSdtwoRR")
(ng #t)
(use "TotalSdtwoMT")

(elim "Td2")

(elim "Ti")
(ng #t)
(use "TotalSdtwoLT")
(ng #t)
(use "TotalSdtwoRT")
(ng #t)
(use "TotalSdtwoLT")
(ng #t)
(use "TotalSdtwoRT")
(ng #t)
(use "TotalSdtwoLT")

(elim "Ti")
(ng #t)
(use "TotalSdtwoMT")
(ng #t)
(use "TotalSdtwoLL")
(ng #t)
(use "TotalSdtwoMT")
(ng #t)
(use "TotalSdtwoRR")
(ng #t)
(use "TotalSdtwoMT")

(elim "Ti")
(ng #t)
(use "TotalSdtwoRT")
(ng #t)
(use "TotalSdtwoLT")
(ng #t)
(use "TotalSdtwoRT")
(ng #t)
(use "TotalSdtwoLT")
(ng #t)
(use "TotalSdtwoRT")

(elim "Td2")

(elim "Ti")
(ng #t)
(use "TotalSdtwoMT")
(ng #t)
(use "TotalSdtwoLL")
(ng #t)
(use "TotalSdtwoMT")
(ng #t)
(use "TotalSdtwoRR")
(ng #t)
(use "TotalSdtwoMT")

(elim "Ti")
(ng #t)
(use "TotalSdtwoRT")
(ng #t)
(use "TotalSdtwoLT")
(ng #t)
(use "TotalSdtwoRT")
(ng #t)
(use "TotalSdtwoLT")
(ng #t)
(use "TotalSdtwoRT")

(elim "Ti")
(ng #t)
(use "TotalSdtwoLL")
(ng #t)
(use "TotalSdtwoMT")
(ng #t)
(use "TotalSdtwoRR")
(ng #t)
(use "TotalSdtwoMT")
(ng #t)
(use "TotalSdtwoRR")
; Proof finished.
(save "JTotal")

(add-program-constant "D" (py "sd=>sd=>sdtwo=>sd"))
(add-computation-rules
 "D L L LL" "L"
 "D L L LT" "L"
 "D L L MT" "M"
 "D L L RT" "M"
 "D L L RR" "M"

 "D L M LL" "L"
 "D L M LT" "L"
 "D L M MT" "M"
 "D L M RT" "M"
 "D L M RR" "R"

 "D L R LL" "L"
 "D L R LT" "M"
 "D L R MT" "M"
 "D L R RT" "M"
 "D L R RR" "R"

 "D M L LL" "L"
 "D M L LT" "L"
 "D M L MT" "M"
 "D M L RT" "M"
 "D M L RR" "R"

 "D M M LL" "L"
 "D M M LT" "M"
 "D M M MT" "M"
 "D M M RT" "M"
 "D M M RR" "R"

 "D M R LL" "L"
 "D M R LT" "M"
 "D M R MT" "M"
 "D M R RT" "R"
 "D M R RR" "R"

 "D R L LL" "L"
 "D R L LT" "M"
 "D R L MT" "M"
 "D R L RT" "M"
 "D R L RR" "R"

 "D R M LL" "L"
 "D R M LT" "M"
 "D R M MT" "M"
 "D R M RT" "R"
 "D R M RR" "R"

 "D R R LL" "M"
 "D R R LT" "M"
 "D R R MT" "M"
 "D R R RT" "R"
 "D R R RR" "R")

; "DTotal"
(set-goal (term-to-totality-formula (pt "D")))
(assume "d^1" "Td1" "d^2" "Td2" "i^" "Ti")
(elim "Td1")

(elim "Td2")

(elim "Ti")
(ng #t)
(use "TotalSdL")
(ng #t)
(use "TotalSdL")
(ng #t)
(use "TotalSdM")
(ng #t)
(use "TotalSdM")
(ng #t)
(use "TotalSdM")

(elim "Ti")
(ng #t)
(use "TotalSdL")
(ng #t)
(use "TotalSdL")
(ng #t)
(use "TotalSdM")
(ng #t)
(use "TotalSdM")
(ng #t)
(use "TotalSdR")

(elim "Ti")
(ng #t)
(use "TotalSdL")
(ng #t)
(use "TotalSdM")
(ng #t)
(use "TotalSdM")
(ng #t)
(use "TotalSdM")
(ng #t)
(use "TotalSdR")

(elim "Td2")

(elim "Ti")
(ng #t)
(use "TotalSdL")
(ng #t)
(use "TotalSdL")
(ng #t)
(use "TotalSdM")
(ng #t)
(use "TotalSdM")
(ng #t)
(use "TotalSdR")

(elim "Ti")
(ng #t)
(use "TotalSdL")
(ng #t)
(use "TotalSdM")
(ng #t)
(use "TotalSdM")
(ng #t)
(use "TotalSdM")
(ng #t)
(use "TotalSdR")

(elim "Ti")
(ng #t)
(use "TotalSdL")
(ng #t)
(use "TotalSdM")
(ng #t)
(use "TotalSdM")
(ng #t)
(use "TotalSdR")
(ng #t)
(use "TotalSdR")

(elim "Td2")

(elim "Ti")
(ng #t)
(use "TotalSdL")
(ng #t)
(use "TotalSdM")
(ng #t)
(use "TotalSdM")
(ng #t)
(use "TotalSdM")
(ng #t)
(use "TotalSdR")

(elim "Ti")
(ng #t)
(use "TotalSdL")
(ng #t)
(use "TotalSdM")
(ng #t)
(use "TotalSdM")
(ng #t)
(use "TotalSdR")
(ng #t)
(use "TotalSdR")

(elim "Ti")
(ng #t)
(use "TotalSdM")
(ng #t)
(use "TotalSdM")
(ng #t)
(use "TotalSdM")
(ng #t)
(use "TotalSdR")
(ng #t)
(use "TotalSdR")
; Proof finished.
(save "DTotal")

; "JDProp"
(set-goal "all d,e,i
  SDToInt d+SDToInt e+2*SDTwoToInt i=SDTwoToInt(J d e i)+4*SDToInt(D d e i)")
(cases)
(cases)
(cases)
(use "Truth-Axiom")
(use "Truth-Axiom")
(use "Truth-Axiom")
(use "Truth-Axiom")
(use "Truth-Axiom")

(cases)
(use "Truth-Axiom")
(use "Truth-Axiom")
(use "Truth-Axiom")
(use "Truth-Axiom")
(use "Truth-Axiom")

(cases)
(use "Truth-Axiom")
(use "Truth-Axiom")
(use "Truth-Axiom")
(use "Truth-Axiom")
(use "Truth-Axiom")

(cases)
(cases)
(use "Truth-Axiom")
(use "Truth-Axiom")
(use "Truth-Axiom")
(use "Truth-Axiom")
(use "Truth-Axiom")

(cases)
(use "Truth-Axiom")
(use "Truth-Axiom")
(use "Truth-Axiom")
(use "Truth-Axiom")
(use "Truth-Axiom")

(cases)
(use "Truth-Axiom")
(use "Truth-Axiom")
(use "Truth-Axiom")
(use "Truth-Axiom")
(use "Truth-Axiom")

(cases)
(cases)
(use "Truth-Axiom")
(use "Truth-Axiom")
(use "Truth-Axiom")
(use "Truth-Axiom")
(use "Truth-Axiom")

(cases)
(use "Truth-Axiom")
(use "Truth-Axiom")
(use "Truth-Axiom")
(use "Truth-Axiom")
(use "Truth-Axiom")

(cases)
(use "Truth-Axiom")
(use "Truth-Axiom")
(use "Truth-Axiom")
(use "Truth-Axiom")
(use "Truth-Axiom")
; Proof finished.
(save "JDProp")

; "YSatClause"
(set-goal "all i allnc x^,y^(
      CoI x^ -> 
      CoI y^ -> 
       exr x^0,y^0 
        ex j,d(
         (P r)((P r)x^ y^)((IntToR r)(SDTwoToInt i))eqd
         (H r)((P r)((P r)x^0 y^0)((IntToR r)(SDTwoToInt j+4*SDToInt d))) &
         CoI x^0 & CoI y^0))")
(assume "i" "x^" "y^" "CoIx" "CoIy")
; We distinguish cases on CoI x^
(inst-with-to "CoIClause" (pt "x^") "CoIx" "xCases")
(elim "xCases")
(drop "xCases")
(assume "x=0")
; We distinguish cases on CoI y^
(inst-with-to "CoIClause" (pt "y^") "CoIy" "yCases")
(elim "yCases")
(drop "yCases")
(assume "y=0")

; Case N,N (i.e., x=0 and y=0)
(intro 0 (pt "x^"))
(intro 0 (pt "y^"))
(ex-intro (pt "J M M i"))
(ex-intro (pt "D M M i"))
(split)
(simp "<-" "JDProp")
(ng #t)
; x+y+i=(x+y+2*i)/2 since x=0 and y=0
(use "Lemma5")
(use "x=0")
(use "y=0")
(split)
(use "CoIx")
(use "CoIy")

; Case N,A (i.e., x=0 and y=(y1+e1)/2)
(drop "yCases")
(assume "yCases1")
(by-assume "yCases1" "y^1" "y1Prop")
(by-assume "y1Prop" "e1" "y1e1Prop")
(intro 0 (pt "x^"))
(intro 0 (pt "y^1"))
(ex-intro (pt "J M e1 i"))
(ex-intro (pt "D M e1 i"))
(split)
(simp "<-" "JDProp")
(ng #t)
; x+y+i=(x+y1+e1+2*i)/2 since x=0 and y=(y1+e1)/2
(use "Lemma6")
(use "x=0")
(use "y1e1Prop")
(split)
(use "CoIx")
(use "y1e1Prop")

; Now the case x=(x1+d1)/2
(drop "xCases")
(assume "xCases1")
(by-assume "xCases1" "x^1" "x1Prop")
(by-assume "x1Prop" "d1" "x1d1Prop")
; We again distinguish cases on CoI y^
(inst-with-to "CoIClause" (pt "y^") "CoIy" "yCases")
(elim "yCases")
(drop "yCases")
(assume "y=0")

; Case A,N (i.e., x=(x1+d1)/2 and y=0)
(intro 0 (pt "x^1"))
(intro 0 (pt "y^"))
(ex-intro (pt "J d1 M i"))
(ex-intro (pt "D d1 M i"))
(split)
(simp "<-" "JDProp")
(ng #t)
; x+y+i=(x1+y+d1+2i)/2 since x=(x1+d1)/2 and y=0
(use "Lemma7")
(use "x1d1Prop")
(use "y=0")
(split)
(use "x1d1Prop")
(use "CoIy")

; Case A,A (i.e., x=(x1+d1)/2 and y=(y1+e1)/2)
(drop "yCases")
(assume "yCases1")
(by-assume "yCases1" "y^1" "y1Prop")
(by-assume "y1Prop" "e1" "y1e1Prop")
(intro 0 (pt "x^1"))
(intro 0 (pt "y^1"))
(ex-intro (pt "J d1 e1 i"))
(ex-intro (pt "D d1 e1 i"))
(split)
(simp "<-" "JDProp")
; x+y+i=(x1+y1+d1+e1+2*i)/2 since x=(x1+d1)/2 and y=(y1+e1)/2
(use "Lemma8")
(use "x1d1Prop")
(use "y1e1Prop")
(split)
(use "x1d1Prop")
(use "y1e1Prop")
; Proof finished.
(save "YSatClause")

(define eterm
  (proof-to-extracted-term (theorem-name-to-proof "YSatClause")))
(define neterm (nt eterm))
(pp neterm)

'(
[i0,v1,v2]
 [if (des v1)
   [if (des v2)
    (J M M i0@D M M i0@v1@v2)
    ([dv3]J M left dv3 i0@D M left dv3 i0@v1@right dv3)]
   ([dv3]
    [if (des v2)
      (J left dv3 M i0@D left dv3 M i0@right dv3@v2)
      ([dv4]J left dv3 left dv4 i0@D left dv3 left dv4 i0@
            right dv3@right dv4)])]
)

(ppc neterm)

'(
[i0,v1,v2]
 [case (des v1)
   ((DummyL sd@@iv) -> 
   [case (des v2)
     ((DummyL sd@@iv) -> J M M i0@D M M i0@v1@v2)
     (Inr dv3 -> J M left dv3 i0@D M left dv3 i0@v1@right dv3)])
   (Inr dv3 -> 
   [case (des v2)
     ((DummyL sd@@iv) -> J left dv3 M i0@D left dv3 M i0@right dv3@v2)
     (Inr dv4 -> 
     J left dv3 left dv4 i0@D left dv3 left dv4 i0@right dv3@right dv4)])]
)

; This term can be read as follows.  Given i0, v1, v2, destruct the
; latter two.  If both are composed, i.e., of the form dv3 and dv4,
; take their components d3,v3 and d4,v4.  Then we obtain J d3 d4 i0
; pair D d3 d4 i0 pair v3 pair v4.

; Putting things together

; "AverageAux"
(set-goal "all i8 allnc x^8,y^8(
       CoI x^8 -> CoI y^8 -> 
       CoI((H r)((H r)((P r)((P r)x^8 y^8)((IntToR r)(SDTwoToInt i8))))))")
(assume "i8" "x^8" "y^8" "CoIx8" "CoIy8")
(assert
 "exr x^1,y^1 ex i1(
       (H r)((H r)((P r)((P r)x^8 y^8)((IntToR r)(SDTwoToInt i8))))eqd
       (H r)((H r)((P r)((P r)x^1 y^1)((IntToR r)(SDTwoToInt i1)))) &
       CoI x^1 & CoI y^1)")
 (intro 0 (pt "x^8"))
 (intro 0 (pt "y^8"))
 (ex-intro (pt "i8"))
 (split)
 (use "InitEqD")
 (split)
 (use "CoIx8")
 (use "CoIy8")
(drop "CoIx8")
(drop "CoIy8")
(assume "ExHyp")
(coind "ExHyp")
(drop "ExHyp")
(assume "z^" "ExHixy")
(intro 1)
(by-assume "ExHixy" "x^" "HypI1")
(by-assume "HypI1" "y^" "HypI2")
(by-assume "HypI2" "i" "iProp")
(inst-with-to "iProp" 'left "z=(x+y+i)/4")
(inst-with-to "iProp" 'right "CoIxy")
(drop "iProp")
(inst-with-to "CoIxy" 'left "CoIx")
(inst-with-to "CoIxy" 'right "CoIy")

(cut "exr x^0,y^0 
   ex j,d(
    (P r)((P r)x^ y^)((IntToR r)(SDTwoToInt i))eqd
    (H r)((P r)((P r)x^0 y^0)((IntToR r)(SDTwoToInt j+4*SDToInt d))) &
    CoI x^0 & CoI y^0)")
(use-with "Id" (make-cterm (goal-to-formula (current-goal))) "?")
(assume "ExQuad")
(by-assume "ExQuad" "x^0" "x0Prop")
(by-assume "x0Prop" "y^0" "y0Prop")
(by-assume "y0Prop" "j" "jProp")
(by-assume "jProp" "d" "dProp")
(inst-with-to "dProp" 'left "x+y+i=(x0+y0+j+4d)/2")
(inst-with-to "dProp" 'right "CoIx0y0")
(drop "dProp")
(inst-with-to "CoIx0y0" 'left "CoIx0")
(inst-with-to "CoIx0y0" 'right "CoIy0")
(drop "CoIx0y0")
(intro 0 (pt "(H r)((H r)((P r)((P r)x^0 y^0)((IntToR r)(SDTwoToInt j))))"))
(ex-intro (pt "d"))
(split)
(drop "x+y+i=(x0+y0+j+4d)/2")
(intro 1)
(intro 0 (pt "x^0"))
(intro 0 (pt "y^0"))
(ex-intro (pt "j"))
(split)
(use "InitEqD")
(split)
(use "CoIx0")
(use "CoIy0")
(simp "z=(x+y+i)/4")
(drop "z=(x+y+i)/4")
; (x+y+i)/4=((x0+y0+j)/4+d)/2 since x+y+i=(x0+y0+j+4d)/2
(use "Lemma9")
(use "x+y+i=(x0+y0+j+4d)/2")
(use "YSatClause")
(use "CoIx")
(use "CoIy")
; Proof finished.
(save "AverageAux")

; "Average"
(set-goal "allnc x^,y^(CoI x^ -> CoI y^ -> CoI((H r)((P r)x^ y^)))")
(assume "x^" "y^" "CoIx" "CoIy")
(assert "exr x^0,y^0 
  ex i(
   (P r)x^ y^ eqd(H r)((P r)((P r)x^0 y^0)((IntToR r)(SDTwoToInt i))) &
   CoI x^0 & CoI y^0)")
 (use "XSubY")
 (use "CoIx")
 (use "CoIy")
(assume "ExHx0y0i")
(by-assume "ExHx0y0i" "x^0" "ExHy0i")
(by-assume "ExHy0i" "y^0" "ExHi")
(by-assume "ExHi" "i" "AndH")
(inst-with-to  "AndH" 'left "x+y=(x0+y0+i)/2")
(inst-with-to "AndH" 'right "CoIx0y0")
(drop "AndH")
(simp "x+y=(x0+y0+i)/2")
(drop "x+y=(x0+y0+i)/2")
(use "AverageAux")
(use "CoIx0y0")
(use "CoIx0y0")
; Proof finished.
(save "Average")

(define eterm (proof-to-extracted-term (theorem-name-to-proof "Average")))
(define neterm (nt eterm))
(pp neterm)

(animate "AverageAux")
; (animate "EqDCompatRev")

(add-var-name "ivw" (py "sdtwo@@iv@@iv"))
(add-var-name "jdvw" (py "sdtwo@@sd@@iv@@iv"))

(define neterm (nt eterm))
; (time (nt eterm))
; 0 ms elapsed cpu time
(pp neterm)
'(
[v0,v1]
 (CoRec sdtwo@@iv@@iv=>iv)(cXSubY v0 v1)
 ([ivw2]
   Inr[let jdvw3
        (cYSatClause left ivw2 left right ivw2 right right ivw2)
        (left right jdvw3@
        (InR sdtwo@@iv@@iv iv)(left jdvw3@right right jdvw3))])
)

(animate "XSubY")
(animate "YSatClause")
(define neterm (nt eterm))
(pp neterm)

'(
[v0,v1]
 (CoRec sdtwo@@iv@@iv=>iv)
 [if (des v0)
   [if (des v1) (MT@v0@v1) ([dv2]JOne M left dv2@v0@right dv2)]
   ([dv2]
    [if (des v1)
      (JOne left dv2 M@right dv2@v1)
      ([dv3]JOne left dv2 left dv3@right dv2@right dv3)])]
 ([ivw2]
   Inr[let jdvw3
        [if (des left right ivw2)
         [if (des right right ivw2)
          (J M M left ivw2@D M M left ivw2@right ivw2)
          ([dv3]
           J M left dv3 left ivw2@
           D M left dv3 left ivw2@left right ivw2@right dv3)]
         ([dv3]
          [if (des right right ivw2)
            (J left dv3 M left ivw2@
            D left dv3 M left ivw2@right dv3@right right ivw2)
            ([dv4]
             J left dv3 left dv4 left ivw2@
             D left dv3 left dv4 left ivw2@right dv3@right dv4)])]
        (left right jdvw3@
        (InR sdtwo@@iv@@iv iv)(left jdvw3@right right jdvw3))])
)

(ppc neterm)

'(
[v0,v1]
 (CoRec sdtwo@@iv@@iv=>iv)
 [case (des v0)
   ((DummyL sd@@iv) -> 
   [case (des v1)
     ((DummyL sd@@iv) -> MT@v0@v1)
     (Inr dv2 -> JOne M left dv2@v0@right dv2)])
   (Inr dv2 -> 
   [case (des v1)
     ((DummyL sd@@iv) -> JOne left dv2 M@right dv2@v1)
     (Inr dv3 -> JOne left dv2 left dv3@right dv2@right dv3)])]
 ([ivw2]
   Inr[let jdvw3
        [case (des left right ivw2)
         ((DummyL sd@@iv) -> 
         [case (des right right ivw2)
           ((DummyL sd@@iv) -> J M M left ivw2@D M M left ivw2@right ivw2)
           (Inr dv3 -> 
           J M left dv3 left ivw2@
           D M left dv3 left ivw2@left right ivw2@right dv3)])
         (Inr dv3 -> 
         [case (des right right ivw2)
           ((DummyL sd@@iv) -> 
           J left dv3 M left ivw2@
           D left dv3 M left ivw2@right dv3@right right ivw2)
           (Inr dv4 -> 
           J left dv3 left dv4 left ivw2@
           D left dv3 left dv4 left ivw2@right dv3@right dv4)])]
        (left right jdvw3@
        (InR sdtwo@@iv@@iv iv)(left jdvw3@right right jdvw3))])
)

; As an example we apply the extracted term to 1/2+1/8=5/8 and
; 1/2+1/4=3/4 (as in [BergerSeisenberger10]).

(define test (mk-term-in-app-form
	       neterm
	       (pt "C R(C M(C R II))")
	       (pt "C R(C R II)")))
(animate "Id")
(define ntest (nt test))

; We look at the first 10 digits of the computed stream.

(define eterm10 (undelay-delayed-corec ntest 10))

(define neterm10 (nt eterm10))
(pp neterm10)
'(
C R
(C R
 (C M
  (C L
   (C M
    (C M
     (C M
      (C M
       (C M
        (C M
         ((CoRec sdtwo@@iv@@iv=>iv)(MT@II@II)
          ([ivw0]
            Inr([if (des left right ivw0)
                  [if (des right right ivw0)
                   (D M M left ivw0)
                   ([dv1]D M left dv1 left ivw0)]
                  ([dv1]
                   [if (des right right ivw0)
                     (D left dv1 M left ivw0)
                     ([dv2]D left dv1 left dv2 left ivw0)])]@
                (InR sdtwo@@iv@@iv iv)
                ([if (des left right ivw0)
                   [if (des right right ivw0)
                    (J M M left ivw0)
                    ([dv1]J M left dv1 left ivw0)]
                   ([dv1]
                    [if (des right right ivw0)
                      (J left dv1 M left ivw0)
                      ([dv2]J left dv1 left dv2 left ivw0)])]@
                 [if (des left right ivw0) (left right ivw0) ([dv1]right dv1)]@
                 [if (des right right ivw0)
                   (right right ivw0)
                   ([dv1]right dv1)])))))))))))))
)

; The result is correct, as (5/8+3/4)/2=11/16=1/2+1/4-1/16.

; Plan: transform (i) rationals and (ii) (abstract) reals into
; streams.  For reals we need ApproxSplit.  By corecursion we define a
; function from the rationals / reals into (the cototal ideals in) iv.

(pp (term-to-type (pt "(CoRec rat=>iv)")))
; rat=>(rat=>uysum(sd@@(iv ysum rat)))=>iv

; We need a step function of type rat=>uysum(sd@@(iv ysum rat)).
; The signed digit is obtained by comparing x with [-1/2,0] and then
; with [0,1/2].  In case x<=0 take L and 2x+1, in case (-1/2<=) x<=1/2
; take M and 2x, and in case 0<=x take R and 2x-1.

; Transformation of rationals into streams.

(define term
  (pt "(CoRec rat=>iv)0([a]
 [if (a<=0)
   (Inr(L@(InR rat iv)(2*a+1)))
   [if (a<=(1#2))
    (Inr(M@(InR rat iv)(2*a)))
    (Inr(R@(InR rat iv)(2*a-1)))]])"))

(define term10 (undelay-delayed-corec term 10))
(define nterm10 (nt term10))
(pp nterm10)
'(
C L
(C R
 (C R
  (C R
   (C R
    (C R
     (C R
      (C R
       (C R
        (C R
         ((CoRec rat=>iv)1
          ([a0]
            [if (a0<=0)
              (Inr(L@(InR rat iv)(2*a0+1)))
              [if (a0<=(1#2))
               (Inr(M@(InR rat iv)(2*a0)))
               (Inr(R@(InR rat iv)(2*a0-1)))]])))))))))))
)

(define stepterm
  (pt "[a][if (a<=0)
   (Inr(L@(InR rat iv)(2*a+1)))
   [if (a<=(1#2))
    (Inr(M@(InR rat iv)(2*a)))
    (Inr(R@(InR rat iv)(2*a-1)))]]"))

(define (rat-to-corec-term x)
  (mk-term-in-app-form
   (pt "(CoRec rat=>iv)")
   (rat-to-rat-term x)
   stepterm))

(define term10 (undelay-delayed-corec (rat-to-corec-term 1/3) 10))
(define nterm10 (nt term10))
(pp nterm10)
'(
C M
(C R
 (C M
  (C R
   (C M
    (C R
     (C M
      (C R
       (C M
        (C R
         ((CoRec rat=>iv)(1#3) ...))))))))))
)

(define term10 (undelay-delayed-corec (rat-to-corec-term 22/28) 10))
(define nterm10 (nt term10))
(pp nterm10)
'(
C R
(C R
 (C M
  (C M
   (C R
    (C M
     (C M
      (C R
       (C M
        (C M
         ((CoRec rat=>iv)(4#7) ...))))))))))
)
