#include <iostream>

using namespace std;

class Liste {
  public:
    double v;

  private:
    Liste* next;

  public:
    explicit Liste(double v_ = 0): v(v_), next(nullptr) {}

    static Liste* einlesen(string n) {
      Liste *start = nullptr, *lauf = start;

      cout << n << ": ";

      double x;
      while (cin >> x) {
        Liste* elem = new Liste{x};
        if (!start)
          start = lauf = elem;
        else {
          lauf->next = elem;
          lauf = elem;
        }
        if (cin.peek() == '\n') break;
      }

      return start;
    };

    friend ostream& operator<<(ostream& stream, const Liste& l) {
      for (const Liste *lauf = &l; lauf; lauf = lauf->next)
        stream << lauf->v << " ";
      return stream;
    }
};

int main() {
  Liste *liste = Liste::einlesen("l");
  if (!liste)
    return 2;

  cout << "l: " << *liste << endl;
  return 0;
}
