#include <iostream>
#include <vector>
#include <string>

using namespace std;

class Vektor {
  private:
    double* ap;
    int len;

  public:
    Vektor() : ap(0), len(0) {}
    Vektor(const vector<double>& v) : len(v.size()) {
      ap = new double[len];
      for (int i = 0; i < len; i++) ap[i] = v[i];
    }

    ~Vektor() {
      delete[] ap;
    }

    double& operator[](int i) {
      return ap[i];
    }

    operator vector<double>() {
      vector<double> v(len);
      for (int i = 0; i < len; i++) v[i] = ap[i];
      return v;
    }

    void ausgeben(string n) {
      for (int i = 0; i < len; i++)
        cout << n << "[" << i << "]: " << ap[i] << " ";
      cout << endl;
    }
};

int main() {
  vector<double> b(4, 2.0);
  Vektor a = b;
  a.ausgeben("a");

  a[2] = 3;
  vector<double> c = a;
  for (unsigned int i = 0; i < c.size(); i++)
    cout << "c[" << i << "]: " << c[i] << " ";
  cout << endl;

  return 0;
}
