#include <iostream>
#include <cmath>

using namespace std;

double trapezoidal(double g(double),
    int n, double a = 0, double b = 1) {
  const double h = (b - a) / n;
  double s = (g(a) + g(b))/2;
  for (int i = 1; i <= n - 1; i++)
    s += g(a + i*h);
  return h * s;
}

double f(double x) {
  x -= 0.25;
  return exp(-x * x);
}

int main() {
  for (int n = 1; n <= 512; n *= 2)
    cout << trapezoidal(f, n) << endl;

  return 0;
}
