#include <iostream>
#include <vector>

using namespace std;

class Polynom {
  private:
    vector<double> coeff;

  public:
    Polynom(const vector<double>& v) : coeff(v) {}

    double operator()(double x) {
      double s = 0, xpot = 1;
      for (vector<double>::size_type i = 0; i < coeff.size(); i++) {
        s += coeff[i] * xpot;
        xpot *= x;
      }
      return s;
    }
};

int main() {
  Polynom p{vector<double>{1, 2, 3}};

  cout << "p(x) = " << p(2) << endl;

  return 0;
}
