#include <iostream>
#include <vector>

using namespace std;

class Polynom {
  private:
    vector<double> coeff;

  public:
    Polynom() {}
    Polynom(int n) : coeff(n + 1) { coeff[n] = 1; }
    Polynom(const vector<double>& v) : coeff(v) {}

    double eval(double x) {
      double s = 0, xpot = 1;
      for (vector<double>::size_type i = 0; i < coeff.size(); i++) {
        s += coeff[i] * xpot;
        xpot *= x;
      }
      return s;
    }
};

int main() {
  int n;
  cout << "n: "; cin >> n;

  vector<double> v(n + 1);
  cout << "a[0] ... a[" << n << "]: ";
  for (int i = 0; i <= n; i++) cin >> v[i];

  double x;
  cout << "x: "; cin >> x;

  Polynom p{v};
  cout << "p(x) = " << p.eval(x) << endl;

  return 0;
}
