#include <iostream>

using namespace std;

template<class T>
  class Vektor {
    private:
      T* ap;
      int len;

    public:
      Vektor(int n = 0, const T& x = T{}): ap(nullptr), len(n) {
        if (!len) return;
        ap = new T[n];
        for (int i = 0; i < len; i++)
          ap[i] = T{x};
      }
      ~Vektor() { if (ap) delete[] ap; }
      Vektor& operator=(const Vektor& b) = delete;

      class iterator {
        friend class Vektor;

        private:
          Vektor* v;
          int pos;

          iterator(Vektor* v_, int pos_ = 0)
            : v(v_), pos(pos_) {}

        public:
          T& operator*() { return v->ap[pos]; }
          iterator& operator++() {
            if (pos < v->len) pos++;
            return *this;
          }
          bool operator!=(const iterator& other) const {
            return v != other.v || pos != other.pos;
          }
      };

      iterator begin() { return iterator{this}; }
      iterator end() { return iterator{this, len}; }
  };

int main() {
  Vektor<int> v{4};
  cout << "v: ";
  unsigned int count = 0;
  for (Vektor<int>::iterator it = v.begin(); it != v.end(); ++it) {
    *it = count++; cout << *it << " ";
  }
  cout << endl;
}
