#include <gtest/gtest.h>
#include <complex>

#include "pnorms.h"

namespace {
  using namespace std;

  const double bound = pnorm_bound<double, 2, 3>();

  TEST(PNorms, ExpectedBound) {
    const double expected_bound = 1.122462048309373;
    EXPECT_NEAR(bound, expected_bound, 1e-12);
  }
  TEST(PNorms, Example1) {
    EXPECT_LE((pnorm_bound<double, 2, 3>(complex<double>{1.5, 2.0})), bound);
  }
  TEST(PNorms, Example2) {
    EXPECT_LE((pnorm_bound<double, 2, 3>(complex<double>{7.0, 7.0})), bound);
  }
  TEST(PNorms, Example3) {
    EXPECT_LE((pnorm_bound<double, 2, 3>(complex<double>{3.7, 42.1})), bound);
  }
}
