#include <iostream>
#include <iomanip>
#include <limits>
#include <cmath>
#include <complex>

using namespace std;

template<class T = double, unsigned int p = 2>
  T pNorm(const complex<T>& z) {
    return pow(pow(abs(z.real()), p) + pow(abs(z.imag()), p), static_cast<T>(1) / p);
}

template<class T = double, T _norm(const complex<T>&) = pNorm<T>>
  class complex_norm : public complex<T> {
    public:
      complex_norm(T real_, T imag_): complex<T>(real_, imag_) {}

      T norm() const {
        return _norm(*this);
      }
};

template<class T = double, unsigned int p = 2>
  using complex_pnorm = complex_norm<T, pNorm<T, p>>;

int main() {
  complex_pnorm<double, 2> z1{1, 1};
  complex_pnorm<double, 3> z2{1, 1};

  double bound = z1.norm() / z2.norm();

  cout << setprecision(numeric_limits<double>::digits10 + 1) << boolalpha;
  cout << bound << endl;

  double real_, imag_;
  while (true) {
    cout << "real, imag = ";
    if (!(cin >> real_ >> imag_)) break;

    z1 = complex_pnorm<double, 2>{real_, imag_};
    z2 = complex_pnorm<double, 3>{real_, imag_};
    double val = z1.norm() / z2.norm();
    cout << val << " " << (val <= bound) << endl;
  }
}
