#include <iostream>
#include <string>

using namespace std;

class IVektor {
  private:
    int m, n;
    double* ap;

  public:
    IVektor(int n_ = 0, int m_ = 0, double x = 0.0) : m(m_), n(n_) {
      ap = new double[n - m];
      for (int i = m; i < n; i++)
        ap[i - m] = x;
    }
    IVektor(const IVektor& v) : m(v.m), n(v.n) {
      ap = new double[n - m];
      for (int i = m; i < n; i++)
        ap[i - m] = v.ap[i - m];
    }
    ~IVektor() {
      delete[] ap;
    }

    IVektor& operator=(const IVektor& v) {
      delete[] ap;

      m = v.m; n = v.n;
      ap = new double[n - m];
      for (int i = m; i < n; i++)
        ap[i - m] = v.ap[i - m];
      return *this;
    }

    double operator[](int i) const {
      return ap[i - m];
    }
    double& operator[](int i) {
      return ap[i - m];
    }

    void ausgeben(string name) {
      for (int i = m; i < n; i++)
        cout << name << "[" << i << "]=" << ap[i - m] << " ";
      cout << endl;
    }
};

int main() {
  IVektor a{3, 1}, b{4}, c{4, 1, 5.0}, d{c}, e;
  a[2] = b[2] = c[2] = 1.0;

  a.ausgeben("a");
  b.ausgeben("b");
  c.ausgeben("c");
  d.ausgeben("d");
  e.ausgeben("e");

  e = c;
  e.ausgeben("e");

  return 0;
}
