#include <iostream>

using namespace std;

class Vektor {
  private:
    double* ap;
    int    len;

  public:
    Vektor(): ap(nullptr), len(0) {} // Leerer Vektor
    Vektor(int n, double x = 0): len(n) { // n Kopien von x
      ap = new double[n];
      for (int i = 0; i < n; i++) ap[i] = x;
    }

    Vektor(Vektor& v): len(v.len) {
      ap = new double[len];
      for (int i = 0; i < len; i++) ap[i] = v.ap[i];
    }

    friend ostream& operator<<(ostream& out, Vektor v) {
      for (int i = 0; i < v.len; i++) {
        if (i > 0) out << ", ";
        out << v.ap[i];
      }
      return out;
    }
    double& operator[](int i) {
      return ap[i];
    }
};

void f(Vektor v) { // Vektor als Parameter um Kopie zu provozieren
  v[1] = 2;
  cout << v << endl;
}

int main() {
  Vektor v{3, 1};

  f(v);

  cout << v << endl;

  return 0;
}
