#include <iostream>

using namespace std;

class Vektor {
  private:
    double* ap;
    unsigned int len;

  public:
    Vektor(int n = 0, double x = 0) : len(n) {
      ap = new double[n];
      for (int i = 0; i < n; i++) ap[i] = x;
    }
    ~Vektor() { delete[] ap; }

    class const_iterator {
      friend class Vektor;

      private:
        const Vektor* v;
        unsigned int pos;

        const_iterator(const Vektor* v_, unsigned int pos_ = 0)
          : v(v_), pos(pos_) {}

      public:
        const double& operator*() const
          { return v->ap[pos]; }

        const_iterator& operator++() {
          if (pos < v->len) pos++;
          return *this;
        }
        bool operator!=(const const_iterator& other) const
          { return v != other.v || pos != other.pos; }
    };

    const_iterator begin() const
      { return const_iterator{this}; }
    const_iterator end() const
      { return const_iterator{this, len}; }
};

int main() {
  const Vektor v{2, 1.141};

  cout << "v: ";
  for ( Vektor::const_iterator it = v.begin();
        it != v.end();
        ++it )
    cout << *it << " ";
  cout << endl;
}
