#include <iostream>
#include <cmath>
#include <functional>

using namespace std;

class NormV {
  private:
    double mw, stdabw;

  public:
    NormV (double mw_ = 0, double stdabw_ = 1)
      : mw(mw_), stdabw(stdabw_) {}

    double operator()(double x) const {
      return M_2_SQRTPI / (2 * M_SQRT2 * stdabw)
        * exp(-((x - mw) * (x - mw)) / (2*stdabw*stdabw));
    }
};

double trapezoidal(function<double(double)> g,
    int n, double a = 0, double b = 1) {
  const double h = (b - a) / n;
  double s = (g(a) + g(b))/2;
  for (int i = 1; i <= n - 1; i++)
    s += g(a + i*h);
  return h * s;
}

double f(double x) {
  x -= 0.25;
  return exp(-x * x);
}

int main() {
  for (int n = 1; n <= 512; n *= 4)
    cout << trapezoidal(f, n) << endl;

  cout << endl;

  for (int n = 1; n <= 512; n *= 4)
    cout << trapezoidal(NormV{}, n) << endl;

  return 0;
}
