#include <iostream>
#include <cmath>
#include <functional>

using namespace std;

double trapezoidal(function<double(double)> g,
    int n, double a = 0, double b = 1) {
  const double h = (b - a) / n;
  double s = (g(a) + g(b))/2;
  for (int i = 1; i <= n - 1; i++)
    s += g(a + i*h);
  return h * s;
}

int main() {
  function<double(double)> f
    = [](double x) -> double { return exp(-x * x); };

  double off = -0.25;
  function<double(double)> g
    = [&f, off](double x) -> double { return f(x + off); };

  for (int n = 1; n <= 512; n *= 2)
    cout << trapezoidal(g, n) << endl;

  return 0;
}
