#include <iostream>
#include <cmath>
#include <functional>

using namespace std;

double trapezoidal(function<double(double)> g,
    int n, double a = 0, double b = 1) {
  const double h = (b - a) / n;
  double s = (g(a) + g(b))/2;
  for (int i = 1; i <= n - 1; i++)
    s += g(a + i*h);
  return h * s;
}

double f(double x, double offset=0) {
  x += offset;
  return exp(-x * x);
}

int main() {
  using namespace placeholders;
  function<double(double)> f_shifted
    = bind(f, _1, -0.25);

  for (int n = 1; n <= 512; n *= 2)
    cout << trapezoidal(f_shifted, n) << endl;

  return 0;
}
