#include <iostream>

using namespace std;

class Complex {
  private:
    double x, y;

  public:
    Complex(double Re = 0, double Im = 0) : x(Re), y(Im) {}

    double real() { return x; }
    double imag() { return y; }

    Complex square() {
      double x2 = x*x - y*y, y2 = 2*x*y;
      x = x2; y = y2;
      return *this;
    }

    friend ostream& operator<<(ostream& out, Complex z) {
      return out << "(" << z.real() << "," << z.imag() << ")";
    }
};

int main() {
  Complex z{1, 1};

  cout << "z davor:     " << z << endl;
  cout << "z quadriert: " << z.square() << endl;
  cout << "z danach:    " << z << endl;

  return 0;
}
