#include <iostream>
#include <iomanip>
#include <valarray>

using namespace std;

slice zeile(size_t i, size_t m, size_t n)
  { return slice(i * n, n, 1); }
slice spalte(size_t j, size_t m, size_t n)
  { return slice(j, m, n); }

void ausgabe_vektor(const valarray<double>& a) {
  for (double x: a)
    cout << setw(3) << x;
}
void ausgabe_matrix(const valarray<double>& a, size_t n) {
  for (size_t k = 0; k < a.size(); k++) {
    cout << setw(3) << a[k];
    if ((k+1) % n == 0)
      cout << endl;
  }
}

int main() {
  size_t i, j, l, m, n;
  cout << "m n: "; cin >> m >> n;
  cout << "i j l: "; cin >> i >> j >> l;

  valarray<double> a(m*n);

  for (size_t k = 0; k < a.size(); k++) a[k] = k;

  cout << "Zeile  " << i << ": ";
  ausgabe_vektor(a[zeile(i, m, n)]); cout << endl;
  cout << "Spalte " << j << ": ";
  ausgabe_vektor(a[spalte(j, m, n)]); cout << endl;

  a[zeile(i, m, n)] += a[zeile(l, m, n)];

  cout << "a:" << endl;
  ausgabe_matrix(a, n); cout << endl;
}
