#include <type_traits>
#include <iostream>
#include <cmath>

using namespace std;

class Approx {
  public:
    int x;

    template<class Integral, enable_if_t<is_integral<Integral>::value, bool> = true>
      Approx(Integral i): x(i) {}

    template<class Floating, enable_if_t<is_floating_point<Floating>::value, bool> = true>
      Approx(Floating d): x(round(d)) {}
};

int main() {
  Approx a1{3}, a2{5.7};

  cout << a1.x << " " << a2.x << endl;
}
