#include <iostream>

using namespace std;

class Complex {
  private:
    double re, im;

  public:
    Complex (double re_=0, double im_=0) : re(re_), im(im_) {}

    Complex quadriere() {
      double re2 = re*re - im*im,
        im2 = 2*re*im;
      re = re2; im = im2;
      return *this;
    }

    friend ostream& operator<<(ostream& out, Complex z) {
      return out << "(" << z.re << "," << z.im << ")";
    }
    friend istream& operator>>(istream& in, Complex& z) {
      char c1, c2, c3;
      double re_, im_;

      in >> c1 >> re_ >> c2 >> im_ >> c3;
      if (c1 != '(' || c2 != ',' || c3 != ')')
        in.setstate(ios::failbit);

      z = Complex(re_, im_);

      return in;
    }
};

int main() {
  Complex z;
  cout << "z: "; cin >> z;

  cout << "z davor:     " << z << endl;
  cout << "z quadriert: " << z.quadriere() << endl;
  cout << "z danach:    " << z << endl;

  return 0;
}
