#include <iostream>

using namespace std;

class Complex {
  private:
    double re, im;

  public:
    Complex(double=0, double=0);

    double real();
    double imag();

    friend Complex conj(Complex);
};

Complex::Complex(double re_, double im_)
  : re(re_), im(im_) {}

double Complex::real() { return re; }
double Complex::imag() { return im; }

Complex conj(Complex z) {
  z.im = -z.im;

  return z;
}

int main() {
  Complex z0, z1{4.0}, z2{1.0, 2.0}, z3 = conj(z2);

  cout <<    "Re z0 = " << z0.real()
       << "   Im z0 = " << z0.imag() << endl;
  cout <<    "Re z1 = " << z1.real()
       << "   Im z1 = " << z1.imag() << endl;
  cout <<    "Re z2 = " << z2.real()
       << "   Im z2 = " << z2.imag() << endl;
  cout <<    "Re z3 = " << z3.real()
       << "   Im z3 = " << z3.imag() << endl;

  return 0;
}
