#include <iostream>

using namespace std;

class Complex {
  private:
    double x, y;

  public:
    Complex (double Re = 0, double Im = 0) : x(Re), y(Im) {}

    friend Complex operator+ (Complex z1, Complex z2) {
      return Complex{ z1.x+z2.x, z1.y+z2.y };
    }

    friend ostream& operator<< (ostream& stream, Complex z) {
      return stream << "(" << z.x << "," << z.y << ")";
    }

    friend istream& operator>> (istream& stream, Complex& z) {
      char c1, c2, c3;
      double x, y;

      stream >> c1 >> x >> c2 >> y >> c3;
      if (c1 != '(' || c2 != ',' || c3 != ')')
        stream.setstate(ios::failbit);

      z = Complex{x, y};

      return stream;
    }
};

int main()
{
  Complex z1, z2;

  cout << "z1 z2: ";
  cin >> z1 >> z2;

  cout << "z1+z2 = " << z1+z2 << endl;

  return 0;
}
