#include <iostream>
#include <iomanip>
#include <valarray>

using namespace std;

class Matrix {
  private:
    int m, n; // Dimension
    valarray<double> a; // Elemente

  public:
    Matrix (int m_ = 0, int n_ = 0, double x = 0)
      : m(m_), n(n_), a(x, m_ * n_) {}

    double operator()(int i, int j) const {
      return a[i*n + j];
    }
    double& operator()(int i, int j) {
      return a[i*n + j];
    }
};

int main() {
  const int m = 4, n = 3;

  Matrix a{m, n};
  for (int i = 0; i < m; i++)
    for (int j = 0; j < n; j++)
        a(i, j) = i*n + j;

  for (int i = 0; i < m; i++) {
    for (int j = 0; j < n; j++) {
        cout << setw(4) << a(i, j);
      }
    cout << endl;
  }

  cout << endl;

  const Matrix b{1, 1, 42};
  cout << b(0, 0) << endl;
}
