#include <vector>
#include <algorithm>
#include <functional>
#include <gtest/gtest.h>

namespace {
  using namespace std;

  class VectorFixture : public testing::Test {
    protected:
      vector<int> vs;

      VectorFixture(): vs({1, 4, 3, 2, 5}) {}
  };

  TEST_F(VectorFixture, DoubleReverse) {
    vector<int> vs_orig(vs);
    reverse(vs.begin(), vs.end());
    reverse(vs.begin(), vs.end());
    EXPECT_EQ(vs_orig, vs);
  }
  TEST_F(VectorFixture, SortReverse) {
    sort(vs.begin(), vs.end(), greater<int>());

    vector<int> vs_comm(vs);
    sort(vs_comm.begin(), vs_comm.end(), less<int>());
    reverse(vs_comm.begin(), vs_comm.end());

    EXPECT_EQ(vs, vs_comm);
  }
}
