#include <iostream>
#include <map>
#include <functional>
#include <cmath>

using namespace std;

using ArithFun = double(double);

const map<string, function<ArithFun>> funs{
  {"exp", static_cast<ArithFun*>(exp)},
  {"ln", static_cast<ArithFun*>(log)},
  {"log10", [](double x) -> double { return log(x)/log(10); }},
  {"cos", static_cast<ArithFun*>(cos)},
  {"sin", static_cast<ArithFun*>(sin)},
  {"arccos", static_cast<ArithFun*>(acos)},
  {"arcsin", static_cast<ArithFun*>(asin)}
};

int main() {
  while (true) {
    string fun;
    double val;
    cout << "> ";
    if (!(cin >> fun >> val))
      break;

    try {
      cout << (funs.at(fun))(val) << endl;
    } catch (const out_of_range&) {
      cout << "Unknown function: " << fun << endl;
    }
  }
}
