#include <iostream>
#include <vector>

using namespace std;

class Complex {
  private:
    double x, y;

  public:
    Complex(double Re = 0, double Im = 0) : x(Re), y(Im) {}

    friend ostream& operator<<(ostream& out, Complex z) {
      return out << "(" << z.x << "," << z.y << ")";
    }
};

class Polynom {
  private:
    vector<double> a; // Koeffizienten

  public:
    Polynom(int n): a(n+1) { a[n] = 1; } // Monom x^n

    int grad() const { return a.size() - 1; }
};

class Vektor {
  private:
    double* ap; // Zeiger auf/C-Array von doubles
    int    len; // Länge

  public:
    Vektor(): ap(nullptr), len(0) {} // Leerer Vektor
    Vektor(int n, double x = 0): len(n) { // n Kopien von x
      ap = new double[n];
      for (int i = 0; i < n; i++) ap[i] = x;
    }

    friend ostream& operator<<(ostream& out, Vektor v) {
      for (int i = 0; i < v.len; i++) {
        if (i > 0) out << ", ";
        out << v.ap[i];
      }
      return out;
    }
};

int main() {
  Polynom p{2};
  cout << p.grad() << endl;

  Complex c{1.0, 2.0};
  cout << c << endl;

  Vektor v{3, 1.0};
  cout << v << endl;
}
