
/* ****************************** StandardPseudoBasis  ******************************
 *
 * StandardPseudoBasis(nf,pseudobasis): ensures that the algebraic numbers in 
 * pseudobasis[1] are given as polmods
 *
 * ****************************************************************************** */

StandardPseudoBasis(nf , pseudobasis , ivar=x) =
{

 local(n,v,q,alg);

 n = length(pseudobasis[1]);

 v = vector(n);

 if(type(pseudobasis[1]) == "t_MAT",          \\ first component is a matrix with
					      \\ algebraic numbers or polmods as entries

   if(type(pseudobasis[1][1,1]) != "t_POLMOD",\\ if we have algebraic numbers, 
					      \\ so we change it to polmods
     pseudobasis[1] = matbasistoalg(nf , pseudobasis[1]);  
   );

   \\ make a vector 
   for(i=1,n,
     for(j=1,n,
       v[i] += pseudobasis[1][j,i] * ivar^(j-1); \\ and than the real basis
     );
   );

   pseudobasis[1] = v;

 );

 return(pseudobasis);

}

addhelp(StandardPseudoBasis , "StandardPseudoBasis(nf,pseudobasis,{ivar=x}): ensures that the algebraic numbers in pseudobasis[1] are given as polmods.");


/********************** ModulePseudoBasisToBasis **************************************
 * 
 * ModulePseudoBasisToBasis(nf, M) computes a basis for the module M 
 * (given by a nxn matrix
 * and a vector of ideals). Always assumes that the class number of nf is 1.
 *
 *************************************************************************************/
ModulePseudoBasisToBasis(nf, M) =
{
    local(n, i, q, alg, N);

        
    n = length(M[2]);
    N = matrix(n,n);
    for(i=1,n,
        q = bnfisprincipal(nf , M[2][i])[2];
        alg = nfbasistoalg(nf , q);
        N[,i] = alg * M[1][,i];
    );

    return(N);
}


