\\  -*-gp-script-*-

/* ****************************** Conjecture.gp ******************************
 *
 * Conjecture: The following function represents our conjecture made in
 *             the paper 'Picard groups and refined discrete logarithms'. 
 * 
 * time-stamp: <Wen, Oct 06 2004 - 08:21>
 *
 * author:     werner bley (mail: werner.bley@math.uni-augsburg.de)
 *             markus endres (mail: parigpo@mendres.org)
 *
 * ********************************************************************* */


Conjecture(bound , d=0 , l=3 , inert=0, logfile=0, ivar=y, greither=0) = 
{

\\ local(KG,p,H,K,v,i,vp,P,k,CR,rcgp,Ath,fAth,DL,fDL,fAthDL,ideal,R,v1,MStick,MStickDL,pi,P1,bid,Ma,MaDL, cv, F, E, OKG, pi1, pi2,complex,OKmodF,gen1,gen2,OEmodF,Gal);

 local(p,H,v,i,vp,k,rcgp,fAth,DL,fDL,fAthDL,ideal,R,v1,MStick,MStickDL,pi,P1,bid,Ma,MaDL, cv, F, E, pi1, pi2,complex,OKmodF,gen1,gen2,OEmodF,Gal);

 \\ initialization ******************************
 H = Mat(l);                        \\ H = subgroup of order l
 K = bnfinit(ivar^2-d);                \\ initalize number field K

 if (K.clgp.no != 1 || kronecker(d,l) == 0, 
     print("Not a valid example for the conjecture: Class number of K != 1 or l ramifies in K\n");
     if (logfile,
        write(logfile, "Not a valid example for the conjecture: Class number of K != 1 or l ramifies in K\n");
     );
     return(0);
 );

 if(d < 0, complex = 1 , complex = 0);

 \\search prime ideals
 p = SearchPrimeIdeals(K,bound,d,l,inert); vp = p[2]; p = p[1];

 KG = GrInit(K , Ginit([l],[l]));              \\ initialzie group ring K[G] with galois group G = Gal(L|K)
 Krcgp = bnrinit(K,l,1);
 
 CR = Picard(KG , GrOKG(KG) , 2 , greither);          \\ compute class group Pic(OKG)

 print("\n\n * * * * * * * * * * * * * * * * * * * * ");
 print(" K.disc = " K.disc);
 print(" l = " l);
 
 if(kronecker(d,l) == -1, 
   print(" (d,l) = " kronecker(d,l) "  --> " l " inert in K/Q" );
  ,
   print(" (d,l) = " kronecker(d,l) "  --> " l " splits in K/Q" );
 );

 OKG = ModuleInit(KG, GrOKG(KG)); R = OKG;
 E = KG.Kch[2].Krhoabs;
 F = ModuleConductor(KG, KG.MaxOrd, OKG, 1)[2];

 OKmodF = idealstar(K,F[1],2);  gen1 = nfbasistoalg(K, OKmodF[2][3]);
 OEmodF = idealstar(E,F[2],2);  gen2 = nfbasistoalg(E, OEmodF[2][3]);



 if(inert, 
   print(" primes with (d,p) = -1 and p^2 = 1 (mod " l ") : "  vp);
  ,
   print(" primes p with (d,p) = 1 and p = 1 (mod " l ") : "  vp);
 );


 print("\n Pic(O_K[G]) = [" CR[1] " , " CR[2] "]");
 print(" E.clgp = [" KG.Kch[2].Krhoabs.clgp[1] " , " KG.Kch[2].Krhoabs.clgp[2] "]");


if(logfile , 
write(logfile , "\n\n\n * * * * * * * * * * * * * * * * * * * * \n K.disc = " d "\n l = " l);
 
 if(kronecker(d,l) == -1, 
   write(logfile , " (d,l) = " kronecker(d,l) "  --> " l " inert in K/Q" );
  ,
   write(logfile , " (d,l) = " kronecker(d,l) "  --> " l " splits in K/Q" );
 );

 if(inert, 
   write(logfile , " primes with (d,p) = -1 and p^2 = 1 (mod " l ") : "  vp);
  ,
   write(logfile , " primes p with (d,p) = 1 and p = 1 (mod " l ") : "  vp);
 );

 write(logfile , "\n Pic(O_K[G]) = [" CR[1] " , " CR[2] "] \n E.clgp = [" KG.Kch[2].Krhoabs.clgp[1] " , " KG.Kch[2].Krhoabs.clgp[2] "]");

);

 for(i=1,length(p),

    if(complex , 

        rcgp = bnrinit(K , p[i] , 0);            \\ compute class field
        v1 = ClassField(rcgp , p[i] , H);         \\ there always exists only one subgroup

        if( v1 == 0, 
	   print1(" irreducible polynomial in ClassField");
           if(logfile , write1(logfile, " irreducible polynomial in ClassField"));
           next();
        );


        P = v1[1];  cv = v1[2];

        Gal = GaloisGen(K,P,cv); KG[2][1]=Gal[1];    \\ rcgp of order 2 ( K(p)|K is cyclic )

	th = NormalBasisElt(KG,P,cv);
        Ath = Atheta(KG , P, th, cv);                \\ compute a locally free OKG-module
      , \\ else

        rcgp = bnrinit(K , p[i] , 1);            \\ flag 1 for bnrstark
        P = bnrstark(rcgp,H);

        Ath = Atheta(KG , P);

     );
     if (IsFreeOverMax(KG, Ath) == 0,
         print1("\nNot a valid example for the conjecture: O_L not free over MaxOrd\n");
         if (logfile,
             write(logfile, "\np" p[i][1]);
             write(logfile, "Not a valid example for the conjecture: O_L not free over MaxOrd\n");
         );
         return(0);
     );
     
     \\ Ok, since we assume h_K = 1 for the conjecture
     pi = nfbasistoalg(KG.nfd, bnfisprincipal(KG.nfd, p[i],1)[2]);
     Ma = Deltaa(KG,CR.F.hnf,l,pi);

     MStick = ComputeMStick(KG,p[i],l);

     DL = PicIsPrincipal(KG , CR , Ath , 0);  \\ solve the discrete logarithm in Pic(OKG)
     
     \\ Using bnfisprincipal is ok, since for our conjecture we actually assume h_K = 1 and
    \\ [O_L] \in ker(\eps), which implies that MStick[2] is principal in E

    pi1 = nfbasistoalg(K, bnfisprincipal(K, p[i],1)[2]);
    pi2 = nfbasistoalg(E, bnfisprincipal(E, MStick[2],1)[2]);

    pi1 = EltPow(gen1, ideallog(K, pi1^-1, OKmodF));
    pi2 = EltPow(gen2, ideallog(E, pi2, OEmodF));
  
    pi1 = nfeltreduce(K, pi1, F[1]);
    pi2 = nfeltreduce(E, pi2, F[2]);
    
    if (kronecker(d,l) == -1,
        M = piK(KG, l, idealhnf(K, pi1), idealhnf(E, pi2), R);
    ,
        M = piK(KG, l, 1, idealhnf(E, pi2), R);
    );

   
    pDL = PicIsPrincipal(KG, CR, M, 0);

    StickDL = bnfisprincipal(KG.Kch[2].Krhoabs, MStick[2],0);

    print1("\n p" p[i][1]);
    print1("   [O_L] in Pic(O_K[G]) = " DL ",");
    print1("   theta((pi^e, alpha)) = " pDL ",");
    print1("   P^(l*theta) = " StickDL);

    if(logfile , write1(logfile , "\n p" p[i][1] "     [O_L] in Pic(O_K[G]) = " DL ",     theta((pi^e, alpha)) = " pDL ",      P^(l*theta) = " StickDL));


 );
}

addhelp(Conjecture , "Conjecture(bound,{d=0},{l=3},{inert=0},{logfile=0},{ivar=y},{greither=0}): This function verifys the conjecture given in the paper 'Picard groups and refined discrete logarithms'. We observed that theta((pi^e,alpha) is equal to the class of [O_L] in Pic(O_K[G]). So, give a bound for the number of primes you will consider, a discriminant d for the base field K, the degree l of the field extension L/K. inert=0 means we only take split primes. If you set logfile to a filename all output will be written to this file. Don't chang ivar=y!. If you set greither to 1, a faster algorithm will be taken to compute (A/F)*. This is only possible if we know that K[G] = K + E.");



\\ compute the Stickelberger ideal
ComputeMStick(KG,p,l) =
{

 local(P1);

 P1 = rnfidealup(KG.Kch[2].Krho , p);
 P1 = idealgentohnf(KG.Kch[2].Krhoabs, P1);
 P1 = idealfactor(KG.Kch[2].Krhoabs , P1);
 return(PStick(KG,1,P1[1,1],l)); 

}


\\ print a matrix in a nice form
printMatrix(str , M) =
{

local(s);

s = matsize(M)[1];
print(str " = ");
for(i=1,s,
  print(M[i,]);
);

}



\\ search prime ideals with a special condition
SearchPrimeIdeals(nf,bound,d,l,inert) =
{

local(m,v,i,rcgp,ideal,p,kro,vp);

 m = 1;
 v = 2; i = 1;
 p = vector(bound);    \\ p: vector of primes satisfying the special conditions


\\ ground field is imaginary quadratic
if(d < 0,

 if(inert,                                     \\ p inert
  while(i <= bound,                            \\ (d|p) == -1 & p = m (mod l) 
   v = nextprime(v);
   if( kronecker(d,v) == -1 && Mod(v^2,l) == m,  
     p[i] = v; i++;
   );
  v++;
  );

 , \\ else p splits

  while(i <= bound,                             \\ (d|p) == 1 & p = m (mod l)
   v = nextprime(v);
   if( kronecker(d,v) == 1 && Mod(v,l) == m,
     p[i] = v; i++;
   );
   v++;
  );
 );


 if(p == [], error(" increase bound "));       \\ no primes found

 v = [];
 for(i=1,length(p),
   ideal = idealprimedec(K , p[i]);            \\ ideal prime decomposition of p in K
   for(j=1,length(ideal),
     v = vecput(v , ideal[j]);
   );
 );

return([v,p]);                                  \\ v contains the prime ideals above the primes in p

);




\\ if ground field is real quadratic
if(inert, kro = -1, kro = 1);

p = []; 

while(i <= 2*bound,                            \\ (d|p) == -1 & p = m (mod l) 
 v = nextprime(v);

 if( kronecker(d,v) == kro,  

   ideal = idealprimedec(nf , v);

   for(j=1,length(ideal),
     
     rcgp = bnrinit(nf , ideal[j], 0);
     
     if( Mod(rcgp.clgp[1] , l) == 0,
       if(i <= 2*bound , p = vecput(p,ideal[j]); i++;);
     );
   );
 );
 v++;
);

if(p == [], error(" increase bound "));       \\ no primes found

vp = vector(length(p),k,p[k][1]);


return([p,vp]);


}

addhelp(SearchPrimeIdeals , "SearchPrimeIdeals(bound,d,l,inert)");






