\\  -*-gp-script-*-

/* ****************************** Ma.gp ******************************
 * 
 * Ma.gp: This file contains some functions to explicitly compute 
 *        Ma from the function delta_a as described in the paper in
 *        the examples section. The delta(a) result is equal to the
 *	  class of M_a. 
 *       
 * The routines are:
 * 
 *        Deltaa(KG,F,l,a)
 *        PStick(KG,a,P1,l)
 *
 * Auxiliary functions: NOT FOR PERSONAL USE
 *
 *        EltPow(gen,c)
 *        piK(KG,l,p1,p2,R)
 *        piK2(KG,l,p2,R)
 *        Autj(a,j)
 *        AutTest(d,l)
 *        
 *
 * time-stamp: <Mon, Oct 04, 2004 - 13:53>
 *
 * author:     markus endres (mail: parigp@mendres.org)
 *             werner.bley (mail: werner.bley@math.uni-augsburg.de)
 *
 * ********************************************************************* */



/* ****************************** Deltaa ******************************
 *
 * Deltaa(KG,F,l,a): Computes explicitly the resulft of delta(a) as
 * described in our paper in the examples section.  
 *
 * Deltaa(KG,F,l,a): KG a group ring, F the conductor, l the degree
 * of the extension, a alpha.
 * 
 * ****************************************************************** */

Deltaa(KG,F,l,a) = 
{

local(Ma,bid,gen,n,c,y1,ay,phiinv,u);

Ma = [ Mat(), Vec() ]; 
Ma[1] = concat(Ma[1],F[1]);   Ma[2] = concat(Ma[2], F[2]);

bid = idealstar(KG.nfd,l,0);
gen = vector(length(bid[3]),k,nfbasistoalg(KG.nfd,bid[3][k]));
n = length(gen);

c = InitMultiCounter(vector(n), bid[2] - vector(n,k,1));

while(c, 

   y1 = EltPow(gen,c[1]);

   ay = Mod(a*y1,KG.Kch[1].Krho[1]);

   u = Mod(y1,KG.Kch[2].Krho[1]);

   phiinv = PhiInv(KG, [ay , u]);

   Ma[1] = concat(Ma[1],phiinv~);
   Ma[2] = concat(Ma[2], [ matid(length(KG.nfd.zk)) ] );

   c = IncMultiCounter(c);              

 );


Ma = ModuleHNF(KG,Ma,1);

return(Ma);


}

addhelp(Deltaa , "Deltaa(KG,F,l,a): Computes explicitly the delta(a) as described in our paper. KG group ring, F conductor in HNF, l degree of extension, a alpha.");




/* ****************************** PStick ******************************
 *
 * PStick(KG,a,P1,l): computes the Stickelberger ideal
 *
 * ****************************************************************** */


PStick(KG,a,P1,l) = 
{

local(E,Erel,P,R,i,j,ideal,k,b,M,var,IdA,id);

R = ModuleInit(KG,GrOKG(KG));
E = KG.Kch[2].Krhoabs;
Erel = KG.Kch[2].Krho;
var = variable(Erel[1]);

P = vector(l-1);

P[1] = idealhnf(E,P1);

P1 = IdealAbsToRel(KG.nfd,E,Erel,P1);
P1 = StandardPseudoBasis(KG.nfd, P1);

IdA = vector(length(P1[2]));
for (i=1, length(P1[2]),
    IdA[i] = rnfidealup(Erel, P1[2][i]);
    IdA[i] = idealgentohnf(E, IdA[i]);
);

for(i=2,l-1,

 j = lift(Mod(i,l)^-1);

 P[i] = subst(P1[1],var,var^j) % Erel[1];

 P[i] = rnfeltreltoabs(Erel,P[i]);

 ideal = idealmul(E, IdA[1], P[i][1]);
 for(k=2,length(P[i]),
  id = idealmul(E, P[i][k], IdA[k]);
  ideal = idealadd(E,ideal,id);
 );

 P[i] = ideal;

);

b = IdealPow(E,P,vector(l-1,i,i));
M = piK(KG,l,a,b,R);
return([M, b]);

}

addhelp(PStick , "PStick(KG,a,P1,l): Stickelberger ideal");






/* ****************************** EltPow ******************************
 *
 * EltPow(gen,c):
 *
 * ****************************************************************** */

EltPow(gen,c) =
{

local(r);
r = prod(i=1,length(gen),gen[i]^c[i]);

return(r);
}

addhelp(EltPow , "EltPow(gen,c)");






/* ****************************** piK ******************************
 *
 * piK(KG,l,p1,p2,R):
 *
 * *************************************************************** */

piK(KG,l,p1,p2,R) =
{

local(M,a,OE,phiinv,a1,a2, b, id);

id = matid(length(KG.nfd.zk));

M = [Mat(), Vec()];
a = idealtwoelt(KG.nfd,p1);
a1 = nfbasistoalg(KG.nfd,a[1]); a2 = nfbasistoalg(KG.nfd,a[2]); a = [a1,a2];

M[1] = concat(M[1], PhiInv(KG, [ Mod(a[1],KG.Kch[1].Krho[1]) , Mod(0,KG.Kch[2].Krho[1]) ])~); 
M[1] = concat(M[1], PhiInv(KG, [ Mod(a[2],KG.Kch[1].Krho[1]) , Mod(0,KG.Kch[2].Krho[1]) ])~); 
M[2] = concat(M[2], [id, id]);
b = IdealAbsToRel(KG.nfd,KG.Kch[2].Krhoabs,KG.Kch[2].Krho, p2);
b = StandardPseudoBasis(KG.nfd, b);

for(i=1,length(b[1]),
 phiinv = PhiInv(KG, [ Mod(0,KG.Kch[1].Krho[1]) , Mod(b[1][i],KG.Kch[2].Krho[1]) ]); 
 M[1] = concat(M[1], phiinv~);
 M[2] = concat(M[2], [ b[2][i]  ]);
);

M = ModuleInit(KG, M);

M = ModuleSection(KG,R,M);


return(M);

}

addhelp(piK , "piK(KG,l,p1,p2)");




/* ****************************** piK2 ******************************
 *
 * piK2(KG,l,p2,R):
 *
 * **************************************************************** */


piK2(KG,l,p2,R) =
{

local(M,a,OE,phiinv,a1,a2, b);

M = Mat();

b = IdealAbsToRel(KG.nfd,KG.Kch[2].Krhoabs,KG.Kch[2].Krho, p2);

for(i=1,length(b),
 phiinv = PhiInv(KG, [ Mod(0,KG.Kch[1].Krho[1]) , Mod(b[i],KG.Kch[2].Krho[1]) ]); 
 M = concat(M, phiinv~);
);

M = ModuleInit(KG, M);

M = ModuleSection(KG,R,M);


return(M);

}

addhelp(piK2 , "piK(KG,l,p1,p2)");





/* ****************************** Autj ******************************
 *
 * Autj(a,j):
 *
 * **************************************************************** */

Autj(a,j) =
{

local(b,l,v);

b = Mat();
l = length(a);

v = vectorv(l);

for(i=1, l,
 for(k=0, l-1,
  
  v[(j*k % l) + 1 ] = a[k+1,i];

 );

  b = concat(b,v);

);

return(b);

}

addhelp(Autj , "Autj(a,j)");


/* ****************************** AutTest ******************************
 *
 * AutTest(d,l):
 *
 * ******************************************************************* */

AutTest(d,l) = 
{

G = Ginit([l],[l]);
K = bnfinit(y^2+d);

KG = GrInit(K,G);

R = GrOKG(KG); R = ModuleInit(KG,R);

F = ModuleConductor(KG,KG.MaxOrd,R,1)[1];

E = KG.Kch[2].Krhoabs;

bid = idealstar(KG.Kch[1].Krhoabs,l,0);

gen = vector(length(bid[3]), i , nfbasistoalg(KG.nfd,bid[3][i]));

CR = Picard(KG,R,1,1);
print(" E.clgp = " [E.clgp[1],E.clgp[2]]);
print(" CR = " [CR[1], CR[2]]);


for(i=1,length(CR[3]),


  M = CR[3][i];

  MDL = PicIsPrincipal(KG,CR,M,0);
  print(" MDL = " MDL);

 for(j=1, l-1,

  fM = Autj(M,j);

  DL = PicIsPrincipal(KG,CR,fM,0);
  print(j " fMDL = " DL);

 );
  
);


}

addhelp(AutTest , "AutTest(d,l)");














