/* ********************************************************************
* 
* Hilbert(d) generates the Hilbert class field L over the quadratic
* number field K = Q(sqrt(d)). O_L is a locally free OKG-module. We
* compute the discrete logarithm of O_L in Pic(OKG).
*
*************************************************************************/



Hilbert(d) = 
{

    if (d % 4 != 1, d = 4*d);
    K = bnfinit(y^2 - d);
    f = quadhilbert(K);
    L = rnfinit(K, f);

    print1("Computation of Gal(L/K)");
    v = NewGaloisGen(L);
    G = Ginit(v[1], v[2]);
    print("     Gal(L/K) = ", G.ord);

    if (print_level > 0, print1("Computation of KG"));
    KG = GrInit(K, G);
    if (print_level > 0, print(" *** done *** \n"));

    OKG = GrOKG(KG);

    print1("Computation of Pic\n ");
    Pic = Picard(KG, OKG, 2,0);
    print("   Pic(OKG) = ", [Pic[1], Pic[2]] );

    aut = AllGroupElt(G, f);

    if (print_level > 0, print("Berechnung von Atheta\n"));
    Ath = Atheta(KG, L[1], 0, aut);
    if (print_level > 0, print("Locally free: ", IsLocallyFree(KG, Ath, OKG)));

    print1("Computation of DL\n ");
    DL = PicIsPrincipal(KG , Pic , Ath , 0);
    print("   DL = ", DL);
    print("\n**************************************************\n");
}

addhelp(Hilbert, "Hilbert(d):generates the Hilbert class field L over the quadratic number field K = Q(sqrt(d)). O_L is a locally free OKG-module. We compute the discrete logarithm of O_L in Pic(OKG)."); 



/*****************************************************************************
*
*  Calls Hilbert(d) for all fundamental discriminants d with low <= d < high
*  and class number h_K with h_min <= h_K <= h_max. h_min must be > 1.
*
*****************************************************************************/

RunHilbert(low, high, h_min, h_max) = 
{
    local(d, QK);
  
    d = low;
    while(d < high, 
        if (isfundamental(d) && d != 1 ,
            QK = bnfinit(x^2 - d);
            if (QK.no >= h_min && QK.no <= h_max,
                print("\n\n d = ", d, "  h_K = ", QK.no);
                Hilbert(d); 
            );
        );
        d = d+1;
    );
}

addhelp(RunHilbert,"RunHilbert(low, high, h_min, h_max): calls Hilbert(d) for all fundamental discriminants d with low <= d < high and class number h_K with h_min <= h_K <= h_max. h_min must be > 1.");