 \\  -*-gp-script-*-

/* ****************************** Examples.gp ******************************
 *
 * Examples.gp: This file contains functions to compute series of 
 * examples for the two papers
 * 
 * - G. Ayala and R. Schertz: Eine Bemerkung zur Galoismodulstruktur in 
 *   Strahlklassenkoerpern ueber imaginaer-quadratsichen Zahlkoerpern.
 *   (JNT 44, 1993).
 * 

 * The routines are:
 *
 *      - Ayala({d=0},{ivar=y})
 *      - SchertzAyala(bound,{d=0},{ord=-1})
 *
 * Auxiliary functions: NOT FOR PERSONAL USE 
 *
 *      - zz_SchertzAyala_rcgpIdealOrder(rcgp,ideal)
 *
 *
 * time-stamp: <Wen, Oct 06, 2004 - 17:46>
 *
 * author:     markus endres (mail: parigp@mendres.org)
 *
 * *********************************************************************** */





/* ****************************** Ayala ******************************
 * 
 * Ayala(d=0): Let d be a discrimant d = { -11,-19,-43,-67,-163 } for
 * the number field K. This verifys, that the class [O_L] is trivial 
 * in Pic(O_K[G]). We consider the field K(p)|K, where p = 2, p inert 
 * in K.
 *
 * ***************************************************************** */

Ayala(d=0,ivar=y) = 
{

 local(K,ideal,rcgp,P,KG,CR,Ath,DL);

 if(!d,
   d = [-11,-19,-43,-67,-163];
   print(" +disc = " d);
   print1(" d? : ");  d = input(); 
 );

 d = -(abs(d)); K = bnfinit(ivar^2-d);       \\ number field K

 ideal = 2;                                  \\ prime 2 is inert in K

 rcgp = bnrinit(K , ideal , 0);              \\ the field K(p)|K

 P = ClassField(rcgp , ideal , Mat(3));      \\ defining polynomial for L|K

 if( P[1] == 0,    \\ P[1] contains the relative polynomial
  print1(" irreducible polynomial in ClassField");
 );

 KG = GrInit(K, Ginit([3],[3]));             \\ group ring K[G]

 CR = Picard(KG , GrOKG(KG) , 2);            \\ Picard group

 Ath = Atheta(KG , P[1]);                       \\ locally free module A_theta

 DL = PicIsPrincipal(KG , CR , Ath , 0);     \\ discrete logarithm in Pic(O_K[G])

}

addhelp(Ayala , "Ayala({d=0},{ivar=y}): Let d be a discrimant d = { -11,-19,-43,-67,-163 } for the number field K. This verifys, that the class [O_L] is equal to 1 in Pic(O_K[G]). We consider the field K(p)|K, where p = 2, p inert in K. ");





/* ****************************** SchertzAyala ******************************
 *
 * SchertzAyala(bound , d=0 , ord=-1): This routine computes a series for the
 * examples in 
 *
 * G. Ayala and R. Schertz: Eine Bemerkung zur Galoismodulstruktur in 
 * Strahlklassenkoerpern ueber imaginaer-quadratsichen Zahlkoerpern.
 * (JNT 44, 1993). 
 *
 * The situation is as follows: Let K a number field with discriminant 
 * d = { -8,-11,-19,-43,-67,-163 }, p a prime with p = 1 (mod 4),
 * kronecker(d,p) = 1 and ord(p) != 1 in Cl_4(K). Let K(p) the ray class
 * field modulo the prime ideal p over K and L the subfield of K(p) with 
 * [L:K] = 2. Than there exists no relative normal integral basis in L, i.e.
 * the class [O_L] in Pic(O_K[G]) is not trivial. 
 *
 * bound is a bound for the number of primes we consider, 
 * d = { -8,-11,-19,-43,-67,-163 }
 * and ord = -1 means that ord(p) != 1 in Cl_4(K).
 *
 * ************************************************************************ */

SchertzAyala(bound , d=0 , ord=-1 , ivar=y) =
{

 local(H,K,rcgp4,vp,p,order,i,v,ideal,l,k,rcgp,Ath,DL,KG,CR,P);

 H = Mat(2);

 if(!d,
   d = [-8,-11,-19,-43,-67,-163];
   print(" disc = " d); 
   print1(" d? : ");  d = input(); 
   print1(" bound? : "); bound = input();
 );

 d = -(abs(d)); K = bnfinit(ivar^2-d);          \\ initalize number field K

 rcgp4 = bnrinit(K ,4 ,1);                   \\ we work in the ray class group mod 4, cl_4(K)


 vp = vector(bound); p = []; order = []; i = 1; v = 2;

 \\ search primes p with the corresponding properties for these examples
 if(ord == -1 ,                               \\ ord(p) != 1 in cl_4(K)

  while(i <= bound,
    v = nextprime(v);

      if( Mod(v,4) == 1 && kronecker(d,v) == 1,   \\ p = 1 (mod 4) and (d|p) = 1, i.e. p splits copmpletely in K
	ideal = idealprimedec(K , v);

	l=0;     
	for(j=1,2,                                \\ p splits only in two prime ideals
	  if( (idealOrder=zz_SchertzAyala_rcgpIdealOrder(rcgp4 , ideal[j])) != [0]~,   \\ ord(p) != 1    
	   p = vecput(p , ideal[j]); order = vecput(order , idealOrder); l=1;
	  );
	);

	if(l==1 , vp[i]=v; i++);
      );

    v++;
  );

 , \\ else

  while(i <= bound,
    v = nextprime(v);

      if( Mod(v,4) == 1 && kronecker(d,v) == 1,   \\ p = 1 (mod 4) and (d|p) = 1, i.e. p splits copmpletely in K
	ideal = idealprimedec(K , v);

	l=0;     
	for(j=1,2,                                \\ p splits only in two prime ideals
	  if( (idealOrder=zz_SchertzAyala_rcgpIdealOrder(rcgp4 , ideal[j]))[1] == ord,   \\ ord(p) == ord
	   p = vecput(p , ideal[j]); order = vecput(order , idealOrder); l=1;
	  );
	);

	if(l==1 , vp[i]=v; i++);

      );

    v++;
  );

 );

 if(p == [], error(" increase bound "));


 \\ search for the polynomial for L|K
 P = 0; k = 1;
 while(!P,
   rcgp = bnrinit(K , p[k] , 1);              \\ compute the ray class group K(p)
   P = ClassField(rcgp , p[k] , H);           \\ and than search for a subfield of degree 2, H = Mat(2);
   k++;
 );


 KG = GrInit(K,Ginit([2],[2]));               \\ initialize the group ring K[G]

 CR = Picard(KG , GrOKG(KG) , 2);             \\ initialize OKG = GrOKG(KG) and compute the Picard group

 print(" d = " d); 
 print(" primes = " vp); 
 print(" Cl_4(K) = [" rcgp4.clgp[1] "," rcgp4.clgp[2] "]"); 
 print(" CR = [" CR[1] "," CR[2] "]");


 for(i=1,length(p),

       print1("\n p" p[i][1]);

       rcgp = bnrinit(K , p[i] , 0);          \\ compute class field

       P = ClassField(rcgp , p[i] , H);       \\ there always exists only one subgroup H of 
					      \\ rcgp of order 2 ( K(p)|K is cyclic ).

       if( P == 0,
	 print1(" irreducible polynomial in ClassField");
	 next();
       );

\\       print1("      " order[i]);

       Ath = Atheta(KG , P[1]);                  \\ compute a locally free OKG-module

       DL = PicIsPrincipal(KG , CR , Ath , 0);\\ solve the discrete logarithm in Pic(OKG)
       print1("      " DL "\n");

 );


}

addhelp(SchertzAyala , "SchertzAyala(bound,{d=0},{ord=-1},{ivar=y}): Let K a number field with discriminant d = { -8,-11,-19,-43,-67,-163 }, p a prime with p = 1 (mod 4), kronecker(d,p) = 1 and ord(p) != 1 in Cl_4(K). Let K(p) the ray class field modulo the prime ideal p over K and L the subfield of K(p) with [L:K] = 2. Than there exists no relative normal integral basis in L, i.e. the class [O_L] in Pic(O_K[G]) is not trivial. bound is a bound for the number of primes we consider, d = { -8,-11,-19,-43,-67,-163 } and ord = -1 means that ord(p) != 1 in Cl_4(K). ");






/* ****************************** Auxiliary functions ******************************
 * 
 *                              - NOT FOR PERSONAL USE -
 * 
 * ******************************************************************************* */

/* ****************************** zz_SchertzAyala_rcgpIdealOrder ******************************
 *
 * zz_SchertzAyala_rcgpIdealOrder(rcgp,ideal): Not for personal use! This function is used by 
 * SchertzAyala to compute the order of an ideal in the ray class group rcgp.
 *
 * ****************************************************************************************** */

\\ not for personal use!
zz_SchertzAyala_rcgpIdealOrder(rcgp , ideal) =
{

 local(DL);

 DL = bnrisprincipal(rcgp , ideal , 0);

 if(DL == []~ || DL == [0]~, return([0]~));  \\ ord(ideal) == 1

 return(DL);                                 \\ ord(ideal) != 1

}

addhelp(zz_SchertzAyala_rcgpIdealOrder , "zz_SchertzAyala_rcgpIdealOrder(rcgp,ideal): Not for personal use! This function is used by SchertzAyala to compute the order of an ideal in the ray class group rcgp.");


idealgentohnf(nf, ideal) = 
{

 local(z);

 z = nfalgtobasis(nf, ideal);
 z[1] = Mat(z[1]);
 mathnf(concat(z));
}








