/* Verify the l-part of the ETNC for cyclic extensions F/Q of degree l=3 and
   elliptic curves E/Q such that rk(E(F)) = rk(E(Q)) = 1 or 2 and satisfies all the
   assumptions in the paper etncV with Macias Castillo.

   The field F is the unique extension of degree l=3 in Q(zeta_p) where p is a prime
   such that p = 1 mod 4.

   Note that the notation in etncV is different. The prime p in etncV is denoted l here.

*/

Attach("/home/bley/magma_projects/lib/RelAlgKTheory.m");
Attach("INB.m");
Attach("etnc.m");

// Attach("myintrinsicsn.m"); 
// Attach("myfunctions.m");
Attach("MazurTatePairing.m");

import "MazurTatePairing.m": ConHom;

SetClassGroupBounds("GRH");

GeneralSelmerGroup := recformat<Sel : GrpAb,
                                SelmerToField : Map,
                                SelmerInvers : Map,
                                SelmerRep : HomGrp,
                                SigmaL1 : SetEnum,
                                xmap : Map
                               >;

ZX<x> := PolynomialRing( Integers() );
DB := CremonaDatabase();

/* Numerically verify refined BSD for elliptic curves of conductor lt 100 such that rk(E) = rk(EK) = 1. */
low := 13; high := 100;  
Listen := AllEllCurves(low, high);
/* Listen[r+1] is a list of all elliptic curves 
   of algebraic rank r with low \le N_E \le high */

filename := "ETNC_V_23_9_2021.out";
prec := 200; PrimeBound := 50;

r := 1; l := 3; n := 1;
Es := Listen[r+1];
ps := [p : p in PrimesUpTo(PrimeBound) | p gt 2 and p mod l^n eq 1];
for x in Es do
    E := x[2];
    for p in ps do
        print "******************* E = ", CremonaReference(E), "l = ", l, "p = ", p, "***********\n";
        start := Cputime(); 
        IsExample, ETNCIsValid:= NonPerfectEtnc(E, l, n, p, prec);
        TimeNeeded := Cputime() - start;
        if IsExample then
            if not ETNCIsValid then
                 fprintf filename, "Counter example to ETNC E\n";
                 print "Counter example to ETNC";
                 print "\n*********** E = ", E, "l = ", l, "p = ", p, "***********\n";
                 assert not ETNCIsValid;
            else
                 print "\n*********** E = ", CremonaReference(E), 
                       " p = ", p, " ETNC_l is valid  ***********\n";
                 fprintf filename, "ETNC is valid for E = %o and p = %o.......time %o minutes \n", CremonaReference(E), p, TimeNeeded/ 60;
            end if;
        else
            print "\n*********** E = ", CremonaReference(E), " p = ", p, " Hypothesis not fullfilled ***********\n";
        end if;
    end for;
end for;


/* Numerically verify refined BSD for elliptic curves of conductor lt 500 such that rk(E) = rk(EK) = 2. */
low := 13; high := 500;
Listen := AllEllCurves(low, high);
/* Listen[r+1] is a list of all elliptic curves
   of algebraic rank r with low \le N_E \le high */

r := 2; l := 3; n := 1;
Es := Listen[r+1];
ps := [p : p in PrimesUpTo(PrimeBound) | p gt 2 and p mod l^n eq 1];
for x in Es do
    E := x[2];
    for p in ps do
        print "******************* E = ", CremonaReference(E), "l = ", l, "p = ", p, "***********\n";
        start := Cputime();
        IsExample, ETNCIsValid:= NonPerfectEtnc(E, l, n, p, prec);
        TimeNeeded := Cputime() - start;
        if IsExample then
            if not ETNCIsValid then
                 fprintf filename, "Counter example to ETNC E\n";
                 print "Counter example to ETNC";
                 print "\n*********** E = ", E, "l = ", l, "p = ", p, "***********\n";
                 assert not ETNCIsValid;
            else
                 print "\n*********** E = ", CremonaReference(E),
                       " p = ", p, " ETNC_l is valid  ***********\n";
                 fprintf filename, "ETNC is valid for E = %o and p = %o.......time %o minutes \n", CremonaReference(E), p, TimeNeeded/ 60;
            end if;
        else
            print "\n*********** E = ", CremonaReference(E), " p = ", p, " Hypothesis not fullfilled ***********\n";
        end if;
    end for;
end for;


