intrinsic pCubedLECimagesK0Rel(~setting)
{ Read all the values of the Epsilon Constant Conjecture,
  as computed by LECcomputeValues, in the same relative K-group. }
    
    local R, x, tm, eLK, dLK_Nr, uLK_Nr, mLK_Nr, tLK_Nr, Krel, Qmpt, IrrG, tup,
          nr, E, r, embeddings, i, charFields, X,Y,Z, mipos,
          subfields, ED, Qm, EDm, incl_EDm_E, KrelED, nr2, t;
    
    // read values
    eLK := setting`eLK;
    dLK_Nr := setting`dLK_Nr;
    uLK_Nr := setting`uLK_Nr;
    mLK_Nr := setting`mLK_Nr;
    tLK_Nr := setting`tLK;

    Krel := setting`Krel;
    Qmpt := setting`Qmpt;
    IrrG := CharacterTable(setting`G);
    
    // tupel
    tup := [ tLK_Nr[i]*dLK_Nr[i]*uLK_Nr[i]*mLK_Nr[i] : i in [1..#tLK_Nr] ];
    // select non-conjugate values in tupel
    nr := [Index(IrrG,h[2]): h in Krel`QG`H];
    nr := [ tup[i] :  i in nr ];
    
    // create smaller extensions E', which still includes
    // the values of the tupel
    E := setting`E;
    vprintf epsConj, 2: "Reduce extension ";
    IndentPush();
    t := Cputime();
    vprintf epsConj, 3: "\n";
    vtime   epsConj, 3: mipos := [MinimalPolynomial(x) : x in nr];
    vprintf epsConj, 3: "Minimal polynomials: %o\n", mipos;
    
    if Max([Degree(f) : f in mipos]) le 4 then
        vtime epsConj, 3: E1 := SplittingField(mipos);
        // vprintf epsConj, 3: "E1: %o\n", E1;
    else
        // start with Q(zeta_m); we need it anyway later 
        vprint epsConj, 3: "using Qm as base field";
        Qm := SplittingField(Polynomial([1] cat [0: i in [1..Exponent(setting`G)-1]] cat [-1]));
        E1 := Qm;
        for f in Reverse(Sort(mipos)) do
            E1 := SplittingField(PolynomialRing(E1)!f);
        end for;
    end if;
    if Degree(E1) gt 1 then
        E1 := OptimizedRepresentation(E1);
        f := DefiningPolynomial(E1);
        c := LCM({Denominator(x) : x in Coefficients(f)});
        if c gt 1 then
            f := c^Degree(f) * Evaluate(f, Polynomial([0, 1/c]));
            E1 := NumberField(f);
            vprintf epsConj, 3: "E': %o\n", E1;
        end if;
    end if;
    t := Cputime(t);
    vprintf epsConj, 2: "Time: %o\n", t;
    IndentPop();
    
    
    if E1 eq Rationals() then
        F := Rationals();
        vprintf epsConj, 3: "No Decomposition in E'\n";
        r := 1;
        
    else
        OE1 := RingOfIntegers(E1);
        vprintf epsConj, 3: "Factorization of p in E'. ";
        vtime   epsConj, 3: PE1 := Factorization(setting`p*RingOfIntegers(OE1))[1,1];
        //F := DecompositionField(PE1);
        // -> bug
        vprintf epsConj, 3: "Compute decomposition field. ";
        vtime   epsConj, 3: F := FixedField(E1, [ sigma : sigma in Automorphisms(E1) |  &and([ sigma(x) in PE1   : x in Generators(PE1) ])]);
        r := Degree(F);
        vprintf epsConj, 3: "Decomposition r=%o\n", r;
        
        if r gt 1 then
            factors := Factorization(setting`p*RingOfIntegers(F));
            // embedding of F into E'
            iota := complex_compatible_embedding(F, E1, 100, false);
            // read prime ideals in E' and choose those belonging to PE1
            factorsE1 := [Factorization(ideal<OE1 | { iota(x) :  x in Generators(F[1])}>) : F in factors ];
            // fix those prime ideal
            PF := [ factors[i] : i in [1..#factors] | #factorsE1[i] eq 1 and factorsE1[i,1,1] eq PE1 ];
            assert #PF eq 1;
            PF := PF[1,1];
        end if;
    end if;
    
    
    // create composite field with character fields
    // F*Q(zeta_m)
    //Qm := CyclotomicField(Exponent(setting`G));
    Qm := SplittingField(Polynomial([1] cat [0: i in [1..Exponent(setting`G)-1]] cat [-1]));
    if Degree(Qm) eq 1 then
        Fm := E1;
    else
        Fm := AbsoluteField(ext<E1 | Factorization(DefiningPolynomial(Qm), E1)[1,1]>);
    end if;
    vprintf epsConj, 3: "Fm: %o\n", Fm;
    
    // read tupel of norms in Fm
    if Degree(E1) eq 1 then
        nr := [* Rationals()!nr[i] : i in [1..#nr]  *];
    else
        vprint epsConj, 3: "compute roots";
        nr := [* root_with_complex_embedding(mipos[i], Fm, nr[i], 100) : i in [1..#nr]  *];
    end if;
    
    setting`E1     := E1;
    setting`F      := F;
    setting`Fm     := Fm;
    setting`mipos  := mipos;
    setting`tupFm  := nr;
    
    vprint epsConj, 3: "compute images in K0rel";
    if r eq 1 then
        print "Case r = 1";
        // no other relative K group needed
        setting`KrelF := setting`Krel;
        
        // no decomposition in E1
        // vprintf epsConj, 3: "No decomposition of %o in E1!\n", setting`p;
        // read tupel directly in character fields Q(chi)
        embeddings := [* complex_compatible_embedding(Krel`QG`H[i,1], Fm, 100, false) : i in [1..#Krel`QG`H] *];
        nr := [* (embeddings[i]^(-1))(nr[i]) : i in [1..#nr] *];
        // read in relative K-group
        X := mapToRelKGroup(Krel, nr);
        print "Before KORelLog eLK = ", eLK;
        Y := K0RelLog(Krel, eLK);
        Z := X+Y;
        // each generator of an ideal is unit in ring of integers ?
        //setting`result := &and([ &and([ IsUnit(Krel`QG`H[i,4]!g) : g in Generators(Z[1,i])]) : i in [1..#Z[1]]])
        //    and Z[2] eq Zero(Parent(Z[2]));

    else
       print "Case r ne 1";
        
        // Consider K_0(Z_p[G], E_Q)
        KrelF := extendGlobalField(Krel, PF);
        setting`KrelF := KrelF;
        embeddings := [* complex_compatible_embedding(KrelF`EG`H[i,1], Fm, 100, false) : i in [1..#KrelF`EG`H] *];
        
        // read tupel in character fields F(chi)
        nr := [* (embeddings[i]^(-1))(nr[i]) : i in [1..#nr] *];
        vprintf epsConj, 4: "nr: %o\n", nr;
        // read in relative K-group
        X := mapToRelKGroup(KrelF, nr);
        
        // cohomological term
        // value in Q(chi)
        nr2 := reducedNorm(Krel, eLK);
        // read in F(chi)
        nr2 := [* KrelF`EG`H[i,3](nr2[i])  : i in [1..#nr2] *];
        // and map to K-group
        Y := mapToRelKGroup(KrelF, nr2);
        
        // sum
        Z := X+Y;
        // each generator of an ideal is unit in ring of integers ?
        //setting`result := &and([ &and([ Valuation(g, KrelF`PrimeIdeals[i,1]) eq 0 : g in Generators(Z[1,i])] ) : i in [1..#Z[1]]])
        //    and Z[2] eq Zero(Parent(Z[2]));
    end if;
    
    setting`X := X;
    setting`Y := Y;
    setting`Z := Z;
end intrinsic;
